#include "DDSMPI_CFT.h"
#include "DDSMPI_Partition.h"
#include "DDSMPI_ByTag.h"
#include <ace/Profile_Timer.h>
#include <vector>
#include "DDSException.h"
#include "GetArgs.h"


int RingTest(int argc, ACE_TCHAR *argv[], DDSMPIBase &m) {
  std::cout << "Starting " << m.GetType() << std::endl;

    m.Initialize(argc, argv);

    int numIterations=1, numIntegers=1;
    GetArg(argc, argv, ACE_TEXT("-i"), numIterations);
    GetArg(argc, argv, ACE_TEXT("-n"), numIntegers);
    int rank = m.GetRank();
    int size = m.GetSize();

    if (size<2) {
        std::cout << "Must have a least 2 processes for this test" << std::endl;
        m.Shutdown();
        return 1;
    }

    std::vector<int> buffer;
    buffer.resize(numIntegers);
    int actualSource, actualTag;
    if (m.GetRank() == 0) {
        ACE_Profile_Timer timer;
        timer.start();
        for (int iter = 0; iter < numIterations; iter++) {
            buffer[0] = 1;  // initially 1 for the master
            
            /*
            MPI_Send(&buffer[0], numIntegers, MPI_INT, 1, 99, MPI_COMM_WORLD);
            MPI_Recv(&buffer[0], numIntegers, MPI_INT, size-1, 99, MPI_COMM_WORLD, &status);
            */
            
            m.Send(&buffer[0], numIntegers*sizeof(int), 1, 99);
            m.Recv(&buffer[0], numIntegers*sizeof(int), size-1, 99, actualSource, actualTag);

            if (buffer[0]!=size) {
                std::ostringstream msg;
                msg << "Final count of " << buffer[0] << " does not match size of " << size;
                throw DDSException(msg.str().c_str());
            }
        }
        timer.stop();
        ACE_Profile_Timer::ACE_Elapsed_Time et;
        timer.elapsed_time(et);
        std::cout << m.GetType() << ":  Total elapsed time for " << numIterations << " iteration(s) and " << numIntegers << " integer(s): " << et.real_time << 
            "s, time per iteration: " << ((et.real_time / double (numIterations)) * 1000000) << "us" << std::endl;
    }
    else {
        for (int iter = 0; iter < numIterations; iter++) {
            /*
            MPI_Recv(&i, numIntegers, MPI_INT, rank-1, 99, MPI_COMM_WORLD, &status);
            i++;  // +1 for the worker
            MPI_Send(&i, numIntegers, MPI_INT, (rank+1)%size, 99, MPI_COMM_WORLD);
            */

            m.Recv(&buffer[0], numIntegers*sizeof(int), rank-1, 99, actualSource, actualTag);
            buffer[0]++;  // +1 for the worker
            m.Send(&buffer[0], numIntegers*sizeof(int), (rank+1)%size, 99);
        }
    }

    m.Shutdown();

    return 0;
}





int ACE_TMAIN(int argc, ACE_TCHAR *argv[]) {
    try {
        // CAREFUL - argv needs duplication so the first test doesn't grab args needed by the second test
        int argc2 = argc;
        int argc3 = argc;
        ACE_TCHAR **argv2 = new ACE_TCHAR *[argc];
        ACE_TCHAR **argv3 = new ACE_TCHAR *[argc];
        for (int i=0; i<argc; i++) {
            argv2[i] = ACE_OS::strdup(argv[i]);
            argv3[i] = ACE_OS::strdup(argv[i]);
        }
        DDSInitialize(argc, argv);

	DDSMPI_CFT cft;
        RingTest(argc, argv, cft);
        DDSMPI_Partition partition;
        RingTest(argc2, argv2, partition); 
        DDSMPI_ByTag topic;
        RingTest(argc3, argv3, topic); 

        DDSShutdown();
    } catch (const DDSException &e) {
        ACE_ERROR((LM_ERROR, ACE_TEXT("DDSException caught: %s\n"), e.what()));
        return -1;
	} catch (const CORBA::Exception& e) {
		e._tao_print_exception("CORBA Exception caught:");
		return -1;
	} catch (const std::exception& e) {
        ACE_ERROR((LM_ERROR, ACE_TEXT("std::exception caught: %s\n"), e.what()));
		return -1;
	}
    return 0;
}
