#include "DDSMPIBase.h"
#include "DDSException.h"
#include "GetArgs.h"
#include "dds/DCPS/Marked_Default_Qos.h"
#include "dds/DCPS/Service_Participant.h"

DDS::DomainParticipantFactory_var _dpf;

void DDSInitialize(int argc, ACE_TCHAR *argv[]) {
    _dpf = TheParticipantFactoryWithArgs(argc, argv);
}


void DDSShutdown() {
    TheServiceParticipant->shutdown();
    ACE_Thread_Manager::instance()->wait();
}


void DDSMPIBase::BaseInitialize(int &argc, ACE_TCHAR *argv[]) {
    // OBTAIN RANK AND SIZE
    if (!GetArg(argc, argv, ACE_TEXT("-r"), _rank))
        _rank = 0;
    if (!GetArg(argc, argv, ACE_TEXT("-s"), _size))
        _size = 1; 
    if (_rank>=_size)
        throw DDSException("Rank must be less than size");

    // CREATE THE DOMAIN PARTICIPANT, TOPIC, PUBLISHER AND SUBSCRIBER
    _dp = _dpf->create_participant(42, PARTICIPANT_QOS_DEFAULT, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
    if (0 == _dp) 
		throw DDSException(_rank, "DDSMPIBase::BaseInitialize(): create_participant() failed");
}


void DDSMPIBase::BaseShutdown() {
    if (0 != _dp) {
        _dp->delete_contained_entities();
        _dpf->delete_participant(_dp);
        _dp = 0;
    }
}


void DDSMPIBase::WaitForSubscriptionCount(::DDS::DataReader_ptr mdr, int subscriptionCount) {
    DDS::Duration_t infinite = {DDS::DURATION_INFINITE_SEC, DDS::DURATION_INFINITE_NSEC};
    DDS::ConditionSeq active;
    DDS::StatusCondition_var sc = mdr->get_statuscondition();
    sc->set_enabled_statuses(DDS::SUBSCRIPTION_MATCHED_STATUS);
    DDS::WaitSet_var ws = new DDS::WaitSet;
    ws->attach_condition(sc);
    DDS::SubscriptionMatchedStatus sm_status;
    while (true) {
        if (mdr->get_subscription_matched_status(sm_status) != DDS::RETCODE_OK)
            throw DDSException(_rank, "DDSMPIBase::WaitForSubscriptionCount(): get_subscription_matched_status() failed");
        if (sm_status.current_count == subscriptionCount) 
            break;
        ws->wait(active, infinite);
    }
    ws->detach_condition(sc);
}



void DDSMPIBase::WaitForPublicationCount(::DDS::DataWriter_ptr mdw, int publicationCount) {
    DDS::Duration_t infinite = {DDS::DURATION_INFINITE_SEC, DDS::DURATION_INFINITE_NSEC};
    DDS::StatusCondition_var sc = mdw->get_statuscondition();
    sc->set_enabled_statuses(DDS::PUBLICATION_MATCHED_STATUS);
    DDS::WaitSet_var ws = new DDS::WaitSet;
    ws->attach_condition(sc);
    DDS::PublicationMatchedStatus status;
    DDS::ConditionSeq active;
    while (true) {
        if (mdw->get_publication_matched_status(status) != DDS::RETCODE_OK)
            throw DDSException(_rank, "DDSMPIBase::WaitForPublicationCount(): get_publication_matched_status() failed");
        if ((status.current_count == publicationCount))
            break;
        ws->wait(active, infinite);
    }
    ws->detach_condition(sc);
}


DDS::DataReader_var DDSMPIBase::CreateDataReader(DDS::Subscriber_ptr sub, DDS::TopicDescription_ptr topic) {
    DDS::DataReaderQos dr_qos;
    sub->get_default_datareader_qos(dr_qos);
    dr_qos.history.kind = DDS::KEEP_ALL_HISTORY_QOS;
    DDS::DataReader_var dr = sub->create_datareader(topic, dr_qos, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
    if (0 == dr)
        throw DDSException(_rank, "DDSMPIBase::CreateDataReader(): create_datareader() failed");
    return dr;
}

DDS::DataWriter_var DDSMPIBase::CreateDataWriter(DDS::Publisher_ptr pub, DDS::Topic_ptr topic) {
    DDS::DataWriterQos dw_qos;
    pub->get_default_datawriter_qos(dw_qos);
    DDS::DataWriter_var dw = pub->create_datawriter(topic, dw_qos, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
    if (0 == dw) 
        throw DDSException(_rank, "DDSMPIBase::CreateDataWriter(): create_datawriter() failed");
    return dw;
}
