#ifndef __DDSMPIBASE_BYRANK_H__
#define __DDSMPIBASE_BYRANK_H__

#include "DDSMPIBase.h"

class DDSMPILib_Export DDSMPIBase_ByRank : public DDSMPIBase {
protected:
    DDS::Topic_var _topic;
    MPIMessage::MessageByRankDataReader_var _mdr;
    DDS::WaitSet_var _dataAvailable;
    DDS::StatusCondition_var _dataAvailableStatus;
    std::list<MPIMessage::MessageByRank> _messages;
    DDS::Subscriber_var _sub;
    std::vector<DDS::InstanceHandle_t> _instances;

    void BeginByRankInitialize(int &argc, ACE_TCHAR *argv[]);
    void EndByRankInitialize(int subscriptionCount);
    void BeginByRankShutdown();
    void CommonByRankSend(MPIMessage::MessageByRankDataWriter_ptr mdw, void *buf, int count, int dest, int tag);
public:
    virtual ~DDSMPIBase_ByRank() {}
    virtual void Recv(void *buf, int count, int source, int tag, int &actualSource, int &actualTag);
};

#endif
