set terminal png
set output "../doc/spider.png"
set title "Single Quad-CPU Machine"

set xlabel "Number of Integers"
set ylabel "Elapsed Time (usec)"
set key left

# plot a histogram, setting the x-axis labels based on col 1 in the data file
set style fill pattern
set style histogram clustered
plot "spider.dat" using 5:xtic(1) title "MPI" with histograms, \
	"" using 3 title "PARTITION" with histograms, \
	"" using 2 title "CFT" with histograms, \
    "" using 4 title "ByTag" with histograms
