#include <mpi.h>
#include <assert.h>
#include <iostream>
#include <vector>
#include <ace/Arg_Shifter.h>
#include <ace/Profile_Timer.h>


bool GetArg(int &argc, ACE_TCHAR *argv[], ACE_TCHAR *arg, int &value) {
    bool foundArg = false;
    ACE_Arg_Shifter arg_shifter(argc, argv);
    while (arg_shifter.is_anything_left()) {
        const ACE_TCHAR *currentArg = 0;
        if ((currentArg = arg_shifter.get_the_parameter(arg)) != 0) {
            value = ACE_OS::atoi(currentArg);
            arg_shifter.consume_arg();
            foundArg = true;  // can't "return true" here as it will drop any arguments following the matched one
        }
        else
            arg_shifter.ignore_arg();
    }
    return foundArg;
}


int main(int argc, char *argv[]) {
    int numIterations = 1, numIntegers = 1;
    GetArg(argc, argv, ACE_TEXT("-i"), numIterations);
    GetArg(argc, argv, ACE_TEXT("-n"), numIntegers);

    int size, rank;
    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &size);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    std::vector<int> buffer;
    buffer.resize(numIntegers);
    MPI_Status status;
    if (rank==0) {
        ACE_Profile_Timer timer;
        timer.start();
        for (int iter = 0; iter < numIterations; iter++) {
            buffer[0] = 1;  // initially 1 for the master
            MPI_Send(&buffer[0], numIntegers, MPI_INT, 1, 99, MPI_COMM_WORLD);
            MPI_Recv(&buffer[0], numIntegers, MPI_INT, size-1, 99, MPI_COMM_WORLD, &status);
            assert(buffer[0] == size);
        }
        timer.stop();
        ACE_Profile_Timer::ACE_Elapsed_Time et;
        timer.elapsed_time(et);
        std::cout << "Total elapsed time for " << numIterations << " iteration(s) and " << numIntegers << " integer(s): " << et.real_time << 
            "s, time per iteration: " << ((et.real_time / double (numIterations)) * 1000000) << "us" << std::endl;
    }
    else {
        for (int iter = 0; iter < numIterations; iter++) {
            MPI_Recv(&buffer[0], numIntegers, MPI_INT, rank-1, 99, MPI_COMM_WORLD, &status);
            buffer[0]++;  // +1 for the worker
            MPI_Send(&buffer[0], numIntegers, MPI_INT, (rank+1)%size, 99, MPI_COMM_WORLD);
        }
    }

    MPI_Finalize();
    return 0;
}
