#include <mpi.h>
#include <assert.h>
#include <iostream>

// to prove that messages, matching by source, can be accepted in any order (not order that they were received)

int main(int argc, char *argv[]) {
    int size, rank;
    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &size);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    MPI_Status status;
    int i = 0; 
    if (rank==0) {


        // 2 - waits to hear from 0, sends to 0
        // 0 - sends to 1, waits on 1, sends to 2, waits on 2
        // 1 - waits to hear from 0, sends to 2, sends to 0
        // so, 0 won't send to 2 until 1 has sent to 2

        i=1;
        MPI_Send(&i, 1, MPI_INT, 1, 999, MPI_COMM_WORLD);
        MPI_Recv(&i, 1, MPI_INT, 1, MPI_ANY_TAG, MPI_COMM_WORLD, &status);
        i=2;
        MPI_Send(&i, 1, MPI_INT, 2, 999, MPI_COMM_WORLD);
        MPI_Recv(&i, 1, MPI_INT, 2, MPI_ANY_TAG, MPI_COMM_WORLD, &status);
        std::cout << "Received  " << i << " from 2" << std::endl;
        MPI_Recv(&i, 1, MPI_INT, 2, MPI_ANY_TAG, MPI_COMM_WORLD, &status);
        std::cout << "Received  " << i << " from 2" << std::endl;
    }
    else if (rank == 1) {
        MPI_Recv(&i, 1, MPI_INT, 0, MPI_ANY_TAG, MPI_COMM_WORLD, &status);
        int j=0;
        MPI_Send(&j, 1, MPI_INT, 2, 999, MPI_COMM_WORLD);
        MPI_Send(&i, 1, MPI_INT, 0, 999, MPI_COMM_WORLD);
    } 
    else if (rank == 2) {
        MPI_Recv(&i, 1, MPI_INT, 0, MPI_ANY_TAG, MPI_COMM_WORLD, &status);
        MPI_Send(&i, 1, MPI_INT, 0, 999, MPI_COMM_WORLD);
        MPI_Recv(&i, 1, MPI_INT, 1, MPI_ANY_TAG, MPI_COMM_WORLD, &status);
        MPI_Send(&i, 1, MPI_INT, 0, 999, MPI_COMM_WORLD);
    }

    MPI_Finalize();
    return 0;
}
