#include "started_pch.h"
#include "MyReplyHandler.h"

// ACE_Thread_Mutex AMI_MyInterfaceHandler_i::lock_;


MyModule_AMI_MyInterfaceHandler_i::MyModule_AMI_MyInterfaceHandler_i () : rank_(-1), reply_received_(false)
{
}


MyModule_AMI_MyInterfaceHandler_i::~MyModule_AMI_MyInterfaceHandler_i (void)
{
}


void MyModule_AMI_MyInterfaceHandler_i::DoWork (
    ::CORBA::Long ami_return_val)
{
    ACE_Guard<ACE_Thread_Mutex> guard(lock_);
    reply_received_ = true;
    rank_ = ami_return_val;
}


void MyModule_AMI_MyInterfaceHandler_i::DoWork_excep (
    ::Messaging::ExceptionHolder * excep_holder)
{
    try {
        excep_holder->raise_exception();
    }
    catch (CORBA::SystemException& e) {
        std::cout << "DoWork System Exception " << e << std::endl;
    }
    catch (CORBA::UserException& e) {
        std::cout << "DoWork User Exception " << e << std::endl;
    }
}


void MyModule_AMI_MyInterfaceHandler_i::DoMoreWork(const char * ami_return_val, ::CORBA::Long val)
{
    // this has no return, so don't care when it executes
}


void MyModule_AMI_MyInterfaceHandler_i::DoMoreWork_excep (
    ::Messaging::ExceptionHolder * excep_holder)
{
    try {
        excep_holder->raise_exception();
    }
    catch (CORBA::SystemException& e) {
        std::cout << "DoWork System Exception " << e << std::endl;
    }
    catch (CORBA::UserException& e) {
        std::cout << "DoWork User Exception " << e << std::endl;
    }
}

