#include <sstream>
#include <ace/High_Res_Timer.h>
#include "../IDL/MyInterfaceC.h"
#include "../IDL/MyInterfaceS.h"
#include "Util.h"

// convenience method to return references
MyModule::MyInterface_var GetReference(CORBA::ORB_ptr orb, int i) {
	// each server will write an IOR to MyInterface<rank>.ior 
    // get a reference to each server's MyInterface in turn
    std::stringstream fileName;
    fileName << "file://MyInterface" << i << ".ior";
    CORBA::Object_var obj = orb->string_to_object(fileName.str().c_str());
    if (CORBA::is_nil(obj.in()))
        throw MyModule::MyException(CORBA::string_dup("Could not get MyInterface IOR"));
    MyModule::MyInterface_var myInterface = MyModule::MyInterface::_narrow(obj.in());
    if (CORBA::is_nil(myInterface.in()))
        throw MyModule::MyException(CORBA::string_dup("IOR was not a MyInterface object reference"));

	return myInterface;
}



void RunTest(void (*f)(CORBA::ORB_ptr orb, PortableServer::POA_ptr poa, int num_servers), CORBA::ORB_ptr orb, PortableServer::POA_ptr poa, int num_servers) {
    std::cout << "********************" << std::endl;
    ACE_High_Res_Timer timer;
    timer.start();
    f(orb, poa, num_servers);
    timer.stop();
    ACE_Time_Value elapsed;
    timer.elapsed_time(elapsed);
    std::cout << "Elapsed: " << elapsed.msec() << " ms" << std::endl;
    std::cout << "********************" << std::endl << std::endl;
}


void RunTest(void (*f)(CORBA::ORB_ptr orb, int num_servers), CORBA::ORB_ptr orb, int num_servers) {
    std::cout << "********************" << std::endl;
    ACE_High_Res_Timer timer;
    timer.start();
    f(orb, num_servers);
    timer.stop();
    ACE_Time_Value elapsed;
    timer.elapsed_time(elapsed);
    std::cout << "Elapsed: " << elapsed.msec() << " ms" << std::endl;
    std::cout << "********************" << std::endl << std::endl;
}
