eval '(exit $?0)' && eval 'exec perl -S $0 ${1+"$@"}'
    & eval 'exec perl -S $0 $argv:q'
    if 0;
 
use strict;
    
use Env '$ACE_ROOT';
use lib "$ACE_ROOT/bin";
use PerlACE::Run_Test;


sub start_server {
    # obtain the arguments
    my $server_path = shift;
    my $server_cmdline = shift;
    my $ior_filename = shift;
  
    # remove the file containing the IOR if it currently exists
    my $ior = PerlACE::LocalFile($ior_filename);
    unlink $ior;
    
    # start the client with output redirected to a file
    my $server_output_file = "server_output.data";
    unlink $server_output_file;
    open (OLDOUT, ">&STDOUT");
    open (STDOUT, ">$server_output_file") or die "can't redirect stdout: $!";
    open (OLDERR, ">&STDERR");
    open (STDERR, ">&STDOUT") or die "can't redirect stderror: $!";
    
    my $server_process = new PerlACE::Process($server_path, $server_cmdline);
    # print $server_process->CommandLine() . "\n";
    $server_process->Spawn();
    
    close (STDERR);
    close (STDOUT);
    open (STDOUT, ">&OLDOUT");
    open (STDERR, ">&OLDERR");

    # wait for the IOR to be written to the file
    if (PerlACE::waitforfile_timed($ior, $PerlACE::wait_interval_for_process_creation) == -1) {
        print STDERR "ERROR: cannot find file <$ior>\n";
        $server_process->Kill();
        unlink $ior;
        exit 1;
    }     
    
    unlink $server_output_file;
  
    return ($ior, $server_process);
}


sub run_client {
    # obtain the arguments
    my $client_path = shift;
    my $client_cmdline = shift;

    # start the client with output redirected to a file
    #my $client_output_file = "client_output.data";
    #unlink $client_output_file;
    #open (OLDOUT, ">&STDOUT");
    #open (STDOUT, ">$client_output_file") or die "can't redirect stdout: $!";
    #open (OLDERR, ">&STDERR");
    #open (STDERR, ">&STDOUT") or die "can't redirect stderror: $!";
    
    my $client = new PerlACE::Process($client_path, $client_cmdline);
    $client->Spawn();
    my $client_return = $client->WaitKill(15);
    
    #close (STDERR);
    #close (STDOUT);
    #open (STDOUT, ">&OLDOUT");
    #open (STDERR, ">&OLDERR");
    
    # clean-up
    #unlink $client_output_file;
    
    if ($client_return != 0) {
        print STDERR "ERROR: Client returned <$client_return>\n";
        exit 1 ;
    }
}


my $client = 'Client_Sync';

my @servers = ();
my $num_servers = 5;

# start servers
for (my $i=0; $i<$num_servers; $i++) {
    print "Starting server " . $i . "\n";
    my ($ior, $process) = start_server("../Server/Server", "$i", "MyInterface$i.ior"); 
    push @servers, $process;
}

# run client
print "Starting $client\n";
run_client("../$client/$client", $num_servers);

# shut down servers
for (my $i=0; $i<$num_servers; $i++) {
    print "Stopping server " . $i . "\n";
    $servers[$i]->Kill();
    unlink "MyInterface$i.ior";
}

exit 0;