#include "started_pch.h"
#include "../IDL/MyInterfaceC.h"
#include <iostream>
#include <sstream>
#include <vector>
#include "../Util/Util.h"

void DoWorkTest(CORBA::ORB_ptr orb, int num_servers) {
	try {
		std::cout << "DoWorkTest" << std::endl;

        // Call methods
        std::vector<CORBA::Long> results;
        for (int i=0; i<num_servers; i++) {
            MyModule::MyInterface_var myInterface = GetReference(orb, i);
            results.push_back(myInterface->DoWork(1000, false));
        }
        
		// Loop and display results
		for (std::vector<CORBA::Long>::iterator it = results.begin(); it != results.end(); it++) 
			std::cout << "Rank: " << *it << std::endl;

   	}
    catch (MyModule::MyException& ex) {
        std::cerr << "MyException exception: " << ex.what << std::endl;
    }
    catch (CORBA::Exception& ex) {
        std::cerr << "CORBA exception: " << ex << std::endl;
    }
}


int main(int argc, char* argv[])
{
    try {
        // initialize
        CORBA::ORB_var orb = CORBA::ORB_init(argc, argv);
        int num_servers = atoi(argv[1]);

        // run the test
        RunTest(DoWorkTest, orb, num_servers);

        // clean up
        orb->destroy();
    }
    catch (CORBA::Exception& ex) {
        std::cerr << "CORBA exception: " << ex << std::endl;
    }
    return 0;
}

