#include "started_pch.h"
#include "MyInterface_i.h"
#include <iostream>
#include <fstream>
#include <sstream>

int main(int argc, char* argv[])
{
    try {
        // Initialize the ORB.
        CORBA::ORB_var orb = CORBA::ORB_init(argc, argv);

        // get rank from command line, write IOR using it
        int rank = atoi(argv[1]);

        //Get a reference to the RootPOA.
        CORBA::Object_var obj = orb->resolve_initial_references("RootPOA");
        PortableServer::POA_var poa = PortableServer::POA::_narrow(obj.in());
        // Activate the POAManager.
        PortableServer::POAManager_var mgr = poa->the_POAManager();
        mgr->activate();
        // Create a servant.
        PortableServer::Servant_var<MyModule_MyInterface_i> servant = new MyModule_MyInterface_i(rank);
        // Register the servant with the RootPOA, obtain its object
        // reference, stringify it, and write it to a file.
        PortableServer::ObjectId_var oid = poa->activate_object(servant.in());
        obj = poa->id_to_reference(oid.in());
        CORBA::String_var str = orb->object_to_string(obj.in());

        std::stringstream fileName;
        fileName << "MyInterface" << rank << ".ior";
	std::ofstream iorFile(fileName.str().c_str());
        iorFile << str.in() << std::endl;
        iorFile.close();
        std::cout << "IOR written to file " << fileName.str() << std::endl;

        // Accept requests from clients.
        orb->run();
        orb->destroy();
        return 0;
    }
        catch (CORBA::Exception& ex) {
        std::cerr << "CORBA exception: " << ex << std::endl;
    }

    return 1;
}
