#include "started_pch.h"
#include "../IDL/MyInterfaceC.h"
#include "MyReplyHandler.h"
#include <iostream>
#include <sstream>
#include <vector>
#include "../Util/Util.h"

void DoWorkTest(CORBA::ORB_ptr orb, PortableServer::POA_ptr poa, int num_servers) {
    try {
        std::cout << "DoWorkTest" << std::endl;

        std::vector<PortableServer::Servant_var<MyModule_AMI_MyInterfaceHandler_i> > servants;
        for (int i=0; i<num_servers; i++) {
            MyModule::MyInterface_var myInterface = GetReference(orb, i);

            // Create a reply-handler servant
            PortableServer::Servant_var<MyModule_AMI_MyInterfaceHandler_i>
                replyHandler_servant = new MyModule_AMI_MyInterfaceHandler_i();
            PortableServer::ObjectId_var oid =
                poa->activate_object(replyHandler_servant.in());
            CORBA::Object_var handler_obj = poa->id_to_reference(oid.in());
            MyModule::AMI_MyInterfaceHandler_var replyHandler =
                MyModule::AMI_MyInterfaceHandler::_narrow(handler_obj.in());
            servants.push_back(replyHandler_servant);

            // Call the method
            myInterface->sendc_DoWork(replyHandler.in(), 1000, false);
        }

        while (1) {
            // Check to see if reply has been returned.
            if (orb->work_pending()) {
                orb->perform_work(); // ORB will invoke reply handler here
                
                // continue to loop until all replies have been received
				int replies_received = 0;
                for (std::vector<PortableServer::Servant_var<MyModule_AMI_MyInterfaceHandler_i> >::iterator it = servants.begin(); 
                    it != servants.end(); it++)
                        if ((*it)->ReplyReceived())
							replies_received++;

				if (replies_received == num_servers)
					break;
            }
        }

        // Loop and display results
        for (std::vector<PortableServer::Servant_var<MyModule_AMI_MyInterfaceHandler_i> >::iterator it = servants.begin(); 
            it != servants.end(); it++) 
            std::cout << "Rank: " << (*it)->GetRank() << std::endl;

    }
    catch (MyModule::MyException& ex) {
        std::cerr << "MyException exception: " << ex.what << std::endl;
    }
    catch (CORBA::Exception& ex) {
        std::cerr << "CORBA exception: " << ex << std::endl;
    }
}

int main(int argc, char* argv[])
{
    try {
        // initialize
        CORBA::ORB_var orb = CORBA::ORB_init(argc, argv);
        int num_servers = atoi(argv[1]);
        
        // be a server so AMI callbacks can be handled
        CORBA::Object_var obj = orb->resolve_initial_references("RootPOA");
        PortableServer::POA_var poa = PortableServer::POA::_narrow(obj.in());
        PortableServer::POAManager_var mgr = poa->the_POAManager();
        mgr->activate();

        // run the test
		RunTest(DoWorkTest, orb, poa, num_servers);

        // clean up
        orb->destroy();
    }
    catch (MyModule::MyException& ex) {
        std::cerr << "MyException exception: " << ex.what << std::endl;
    }
    catch (CORBA::Exception& ex) {
        std::cerr << "CORBA exception: " << ex << std::endl;
    }
    return 0;
}

