#ifndef MYREPLYHANDLER_H_
#define MYREPLYHANDLER_H_

#include "../IDL/MyInterfaceS.h"

class  MyModule_AMI_MyInterfaceHandler_i
  : public virtual POA_MyModule::AMI_MyInterfaceHandler
{
    ACE_Thread_Mutex lock_;
    bool reply_received_;
    ::CORBA::Long rank_;
public:
  // Constructor 
  MyModule_AMI_MyInterfaceHandler_i ();

  MyModule_AMI_MyInterfaceHandler_i(const MyModule_AMI_MyInterfaceHandler_i &other) {
      // don't duplicate the lock as it is local
      reply_received_ = other.reply_received_;
      rank_ = other.rank_;
  }
  
  // Destructor 
  virtual ~MyModule_AMI_MyInterfaceHandler_i ();
  
  virtual
  void DoWork (
      ::CORBA::Long ami_return_val);
  
  virtual
  void DoWork_excep (
      ::Messaging::ExceptionHolder * excep_holder);
  
  virtual
  void DoMoreWork(const char * ami_return_val, ::CORBA::Long val);
  
  virtual
  void DoMoreWork_excep (
      ::Messaging::ExceptionHolder * excep_holder);

  int GetRank() { return rank_; }
  bool ReplyReceived() { return reply_received_; }
};

#endif