#include "started_pch.h"
#include "MyInterface_i.h"
#include "ace/OS_NS_unistd.h"

void MyModule_MyInterface_i::Sleep(int ms) {
    ACE_Time_Value tv;
    tv.set(ms / 1000.0);
    ACE_OS::sleep(tv); 
}


MyModule_MyInterface_i::MyModule_MyInterface_i (int rank) : rank_(rank)
{
}


MyModule_MyInterface_i::~MyModule_MyInterface_i (void)
{
}

::CORBA::Long MyModule_MyInterface_i::DoWork(::CORBA::Long delay_ms, CORBA::Boolean throw_exception)
{
    Sleep(delay_ms);
	if (throw_exception)
		throw MyModule::MyException(::CORBA::string_dup("DoWork exception"));
    return rank_;
}

char *MyModule_MyInterface_i::DoMoreWork(::CORBA::Long delay_ms, CORBA::Boolean throw_exception, CORBA::Long_out val)
{
    Sleep(delay_ms);
	if (throw_exception)
		throw MyModule::MyException(::CORBA::string_dup("DoMoreWork exception"));
	val = rank_;
	char buf[20];
	ACE_OS::itoa(rank_, buf, 10);
	return ::CORBA::string_dup(buf);
}

