using System;

namespace CS_COM
{
    // careful - this has to match the architecture of the control, so must be compiled as x64

    class CS_COM
    {
        static void Main(string[] args)
        {
            // invoke the COM object
            CPPWrapper_COMLib.ICOMWrapper w = new CPPWrapper_COMLib.COMWrapper();
            long pContext;
            w.CreateContext(out pContext);

            string buf;
            w.JavaName(pContext, out buf);
            Console.WriteLine(buf);

            long pJavaCustom, pJavaAdder;
            w.JavaCreateCustom(pContext, 3, out pJavaCustom);
            w.JavaCreateAdder(pContext, out pJavaAdder);

            int result;
            w.JavaAdd(pContext, pJavaAdder, 9, pJavaCustom, out result);
            Console.WriteLine(result);

            w.ScalaName(pContext, out buf);
            Console.WriteLine(buf);

            long pScalaCustom, pScalaAdder;
            w.JavaCreateCustom(pContext, 4, out pScalaCustom);
            w.JavaCreateAdder(pContext, out pScalaAdder);

            w.JavaAdd(pContext, pScalaAdder, 7, pScalaCustom, out result);
            Console.WriteLine(result);

        }
    }
}



