#include "Context.h"
#include <cstring>

Context::Context(): _jvm(0), _env(0),
	_clsJavaAdder(0), _midJavaAdderConstructor(0), _midJavaAdderAdd(0), _midJavaAdderName(0),
	_clsScalaAdder(0), _midScalaAdderConstructor(0), _midScalaAdderAdd(0),
	_clsScalaAdderDollar(0), _midScalaAdderDollarName(0),
	_clsScalaCustom(0), _midScalaCustomConstructor(0), _midScalaCustomI(0)
{
	// create the VM
	// careful - can only have one VM:  https://community.oracle.com/thread/1552316?start=0&tstart=0
	JavaVMInitArgs vmArgs;
	JavaVMOption vmOptions;
	vmOptions.optionString = 
        "-Djava.class.path="
        "..\\..\\javalib\\target\\scala-2.10\\javalib-assembly-1.0.jar;"
        "..\\..\\scalalib\\target\\scala-2.10\\scalalib-assembly-1.0.jar";
	vmArgs.version = JNI_VERSION_1_6;
	vmArgs.nOptions = 1;
	vmArgs.options = &vmOptions;
	vmArgs.ignoreUnrecognized = 0;

	int success = JNI_CreateJavaVM(&_jvm, (void**)&_env, &vmArgs);
	if (success < 0) 
		return;

	// find the Adder class
	_clsJavaAdder = _env->FindClass("javalib/Adder");
	if (_clsJavaAdder != 0) {
		// use "javap -s cls.class" to get the signature
		_midJavaAdderConstructor = _env->GetMethodID(_clsJavaAdder, "<init>", "()V");		
		_midJavaAdderAdd = _env->GetMethodID(_clsJavaAdder, "add", "(ILjavalib/Custom;)I");
		_midJavaAdderName = _env->GetStaticMethodID(_clsJavaAdder, "name", "()Ljava/lang/String;");
	} 

	_clsScalaAdder = _env->FindClass("scalalib/Adder");
	if (_clsScalaAdder != 0) {
		_midScalaAdderConstructor = _env->GetMethodID(_clsScalaAdder, "<init>", "()V");
		_midScalaAdderAdd = _env->GetMethodID(_clsScalaAdder, "add", "(ILscalalib/Custom;)I");
	} 

	_clsScalaAdderDollar = _env->FindClass("scalalib/Adder$");
	if (_clsScalaAdderDollar != 0) {
		// no constructor
		// method isn't actually static
		_midScalaAdderDollarName = _env->GetMethodID(_clsScalaAdderDollar, "name", "()Ljava/lang/String;");
	} 

	// find the Custom class
	_clsJavaCustom = _env->FindClass("javalib/Custom");
	if (_clsJavaCustom != 0) {
		// get returns int
		_midJavaCustomConstructor = _env->GetMethodID(_clsJavaCustom, "<init>", "(I)V");
		_midJavaCustomGet = _env->GetMethodID(_clsJavaCustom, "get", "()I");
	} 

	_clsScalaCustom = _env->FindClass("scalalib/Custom");
	if (_clsScalaCustom != 0) {
		// i returns Integer
		_midScalaCustomConstructor = _env->GetMethodID(_clsScalaCustom, "<init>", "(I)V");
		_midScalaCustomI = _env->GetMethodID(_clsScalaCustom, "i", "()I");
	}
}

Context::~Context() {
	if (_jvm)
		_jvm->DestroyJavaVM();
}

void *Context::JavaCreateAdder() {
	if (_env && _clsJavaAdder && _midJavaAdderConstructor)
		return _env->NewObject(_clsJavaAdder, _midJavaAdderConstructor);  // jobject
	return 0;
}

void *Context::JavaCreateCustom(long i) {
	// a jint is really a long
	if (_env && _clsJavaCustom && _midJavaCustomConstructor)
		return _env->NewObject(_clsJavaCustom, _midJavaCustomConstructor, (jint)i);
	return 0;
}

long Context::JavaAdd(void *pObjAdder, long a, void *pObjCustom) {
	if (_env && pObjAdder && _midJavaAdderAdd && pObjCustom)
		return _env->CallIntMethod((jobject)pObjAdder, _midJavaAdderAdd, (jint)a, (jobject)pObjCustom);
	return 0;
}

void Context::JavaName(char *buf, int buflen) {
	if (_env && _clsJavaAdder && _midJavaAdderName) {
		jstring strName = (jstring)_env->CallStaticObjectMethod(_clsJavaAdder, _midJavaAdderName);
		const char *pName = _env->GetStringUTFChars(strName, 0);
		strncpy_s(buf, buflen, pName, _TRUNCATE);
		_env->ReleaseStringUTFChars(strName, pName);
	}
}


void *Context::ScalaCreateAdder() {
	if (_env && _clsScalaAdder && _midScalaAdderConstructor)
		return _env->NewObject(_clsScalaAdder, _midScalaAdderConstructor);
	return 0;
}

void *Context::ScalaCreateCustom(long i) {
	if (_env && _clsScalaCustom && _midScalaCustomConstructor)
		return _env->NewObject(_clsScalaCustom, _midScalaCustomConstructor, (jint)i);
	return 0;
}

long Context::ScalaAdd(void *pObjAdder, long a, void *pObjCustom) {
	if (_env && pObjAdder && _midScalaAdderAdd && pObjCustom)
		return _env->CallIntMethod((jobject)pObjAdder, _midScalaAdderAdd, (jint)a, (jobject)pObjCustom);
	return 0;
}

void Context::ScalaName(char *buf, int buflen) {
	if (_env && _clsScalaAdderDollar && _midScalaAdderDollarName) {
		// not a static method
		jstring strName = (jstring)_env->CallObjectMethod(_clsScalaAdderDollar, _midScalaAdderDollarName);
		const char *pName = _env->GetStringUTFChars(strName, 0);
		strncpy_s(buf, buflen, pName, _TRUNCATE);
		_env->ReleaseStringUTFChars(strName, pName);
	}
}

