// COMWrapper.cpp : Implementation of CCOMWrapper

#include "stdafx.h"
#include "COMWrapper.h"
#include "Context.h"


// CCOMWrapper

BSTR ToBSTR(char *buf) {
	int n = MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, buf, -1, NULL, 0);
	wchar_t *wbuf = new wchar_t[n];
	MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, buf, -1, wbuf, n);
	BSTR bstr = SysAllocString((const OLECHAR*)wbuf);
	delete wbuf;
	return bstr;
}


STDMETHODIMP CCOMWrapper::CreateContext(LONGLONG* pContext)
{
	*pContext = reinterpret_cast<LONGLONG>(new Context());

	return S_OK;
	// return E_FAIL;
}

// returning, say, E_FAIL, will cause this exception from C#
// System.Runtime.InteropServices.COMException: Error HRESULT E_FAIL has been returned from a call to a COM component.


STDMETHODIMP CCOMWrapper::JavaName(LONGLONG pContext, BSTR* buf)
{
	char b[30];
	Context *pC = reinterpret_cast<Context *>(pContext);
	pC->JavaName(b, sizeof(b));
	*buf = ToBSTR(b);

	return S_OK;
}


STDMETHODIMP CCOMWrapper::JavaCreateCustom(LONGLONG pContext, LONG i, LONGLONG* pJavaCustom)
{
	Context *pC = reinterpret_cast<Context *>(pContext);
	*pJavaCustom = reinterpret_cast<LONGLONG>(pC->JavaCreateCustom(i));

	return S_OK;
}


STDMETHODIMP CCOMWrapper::JavaCreateAdder(LONGLONG pContext, LONGLONG* pJavaAdder)
{
	Context *pC = reinterpret_cast<Context *>(pContext);
	*pJavaAdder = reinterpret_cast<LONGLONG>(pC->JavaCreateAdder());

	return S_OK;
}


STDMETHODIMP CCOMWrapper::JavaAdd(LONGLONG pContext, LONGLONG pJavaAdder, LONG a, LONGLONG pJavaCustom, LONG* result)
{
	Context *pC = reinterpret_cast<Context *>(pContext);
	void *pAdder = reinterpret_cast<void *>(pJavaAdder);
	void *pCustom = reinterpret_cast<void *>(pJavaCustom);
	*result = pC->JavaAdd(pAdder, a, pCustom);

	return S_OK;
}



STDMETHODIMP CCOMWrapper::ScalaName(LONGLONG pContext, BSTR* buf)
{
	char b[30];
	Context *pC = reinterpret_cast<Context *>(pContext);
	pC->ScalaName(b, sizeof(b));
	*buf = ToBSTR(b);

	return S_OK;
}


STDMETHODIMP CCOMWrapper::ScalaCreateCustom(LONGLONG pContext, LONG i, LONGLONG* pScalaCustom)
{
	Context *pC = reinterpret_cast<Context *>(pContext);
	*pScalaCustom = reinterpret_cast<LONGLONG>(pC->ScalaCreateCustom(i));

	return S_OK;
}


STDMETHODIMP CCOMWrapper::ScalaCreateAdder(LONGLONG pContext, LONGLONG* pScalaAdder)
{
	Context *pC = reinterpret_cast<Context *>(pContext);
	*pScalaAdder = reinterpret_cast<LONGLONG>(pC->ScalaCreateAdder());

	return S_OK;
}


STDMETHODIMP CCOMWrapper::ScalaAdd(LONGLONG pContext, LONGLONG pScalaAdder, LONG a, LONGLONG pScalaCustom, LONG* result)
{
	Context *pC = reinterpret_cast<Context *>(pContext);
	void *pAdder = reinterpret_cast<void *>(pScalaAdder);
	void *pCustom = reinterpret_cast<void *>(pScalaCustom);
	*result = pC->ScalaAdd(pAdder, a, pCustom);

	return S_OK;
}
