#include "Context.h"

using namespace System;

namespace CPPWrapper_DotNET {

	public ref class CPPWrapper_DotNET {
		Context *_pContext;
	public:

		// a .NET compatible interface
		CPPWrapper_DotNET() {
			_pContext = new Context();
		}

		~CPPWrapper_DotNET() {
			delete _pContext;
		}

		String^ JavaName() {
			char buf[40];
			_pContext->JavaName(buf, sizeof(buf));
			return gcnew String(buf);
		}

		IntPtr JavaCreateCustom(long i) {
			return IntPtr(_pContext->JavaCreateCustom(i));
		}

		IntPtr JavaCreateAdder() {
			return IntPtr(_pContext->JavaCreateAdder());
		}

		Int64 JavaAdd(IntPtr pJavaAdder, long a, IntPtr pJavaCustom) {
			return _pContext->JavaAdd(pJavaAdder.ToPointer(), a, pJavaCustom.ToPointer());
		}

		String^ ScalaName() {
			char buf[40];
			_pContext->ScalaName(buf, sizeof(buf));
			return gcnew String(buf);
		}

		IntPtr ScalaCreateCustom(long i) {
			return IntPtr(_pContext->ScalaCreateCustom(i));
		}

		IntPtr ScalaCreateAdder() {
			return IntPtr(_pContext->ScalaCreateAdder());
		}

		Int64 ScalaAdd(IntPtr pScalaAdder, long a, IntPtr pScalaCustom) {
			return _pContext->ScalaAdd(pScalaAdder.ToPointer(), a, pScalaCustom.ToPointer());
		}
	};

}