// in one window run         AddServer.exe -ior server.ior
// in another window run     AddClient -ior server.ior -add 7 9

namespace CSServer
{
    using System;
    using System.IO;

    using com.ociweb.JavaAddLib;
    using org.apache.commons.cli;
    using System.Diagnostics;

    class CSServer
    {
        public static CommandLine ParseArgs(String[] args)
        {
            try
            {
                // http://commons.apache.org/cli/usage.html
                CommandLineParser parser = new PosixParser();
                Options options = new Options();
                options.addOption("?", "help", false, "print this message");
                options.addOption(null, "ORBInitialPort", true, "nameserver port (required)");
                options.addOption(null, "ORBInitialHost", true, "nameserver host");
                CommandLine line = parser.parse(options, args);

                if (line.hasOption("help") || !line.hasOption("ORBInitialPort"))
                {
                    HelpFormatter formatter = new HelpFormatter();
                    formatter.printHelp("Server", options);
                    return null;
                }

                return line;
            }
            catch (ParseException e)
            {
                Console.WriteLine(e.getMessage());
                return null;
            }
        }

        static void Main(string[] args)
        {
            try
            {
                CommandLine line = ParseArgs(args);
                if (line == null)
                    return;

                // // http://stackoverflow.com/questions/35842/how-can-a-java-program-get-its-own-process-id
                String instanceName = "CS_" + Process.GetCurrentProcess().Id + "@" + Environment.MachineName;
                AddServer s = new AddServer();

                Console.CancelKeyPress +=
                    new ConsoleCancelEventHandler(
                        (object obj, ConsoleCancelEventArgs e) =>
                        {
                            e.Cancel = true;
                            Console.WriteLine("Shutting down...");
                            s.shutdown();
                        });

                s.init(args);
                Console.WriteLine("Running " + instanceName);
                s.run(instanceName);
            }
            catch (Exception e)
            {
                Console.WriteLine(e);
            }
        }
    }
}



