// in one window run         AddServer.exe -ior server.ior
// in another window run     AddClient -ior server.ior -add 7 9

// if using the naming service
// in one window run   orbd -ORBInitialPort 1050

namespace CSClient
{
    using System;
    using System.IO;

    using org.apache.commons.cli;
    using com.ociweb.JavaAddLib;

    class CSClient
    {
        public static CommandLine ParseArgs(String[] args)
        {
            try
            {
                // http://commons.apache.org/cli/usage.html
                CommandLineParser parser = new PosixParser();
                Options options = new Options();
                options.addOption("?", "help", false, "print this message");
                options.addOption(null, "ORBInitialPort", true, "nameserver port (required)");
                options.addOption(null, "ORBInitialHost", true, "nameserver host");

                // http://stackoverflow.com/questions/4903296/scala-error-compiling-optionbuilder/4903434#4903434
                // http://stackoverflow.com/questions/3610309/java-static-confusion

                Option o = new Option(null, "add", true, "two numbers to add (required)");
                o.setArgs(2);
                options.addOption(o);
                /*
                options.addOption( OptionBuilder.withLongOpt("add")
                        .withDescription( "two numbers to add (required)" )
                        .hasArgs(2)
                        .create());
                */
                CommandLine line = parser.parse(options, args);

                if (line.hasOption("help") || !line.hasOption("add") || !line.hasOption("ORBInitialPort"))
                {
                    HelpFormatter formatter = new HelpFormatter();
                    formatter.printHelp("Client", options);
                    return null;
                }

                return line;
            }
            catch (ParseException e)
            {
                Console.WriteLine(e.getMessage());
                return null;
            }
        }

        static void Main(string[] args)
        {
            CommandLine line = ParseArgs(args);
            if (line == null)
                return;

            String[] opt = line.getOptionValues("add");
            int x = Convert.ToInt32(opt[0]);
            int y = Convert.ToInt32(opt[1]);

            AddClient c = new AddClient();
            c.init(args);

            java.util.Vector refs = c.list();  // Java generic doesn't seem to be converted
            if (refs.size() == 0)
                Console.WriteLine("No servers found");
            else
            {
                java.util.Iterator it = refs.iterator();
                while (it.hasNext())
                {
                    Ref r = (Ref)it.next();
                    Console.Write(r.Name + ": ");
                    try
                    {
                        Console.WriteLine(c.add(r, x, y));
                    }
                    catch (Exception e)  // Java exceptions become subclasses of .NET Exception class
                    {
                        Console.WriteLine(e.Message);
                    }
                }
            }

            c.destroy();

        }
    }
}



