using System;
using System.Runtime.Remoting.Channels;
using Ch.Elca.Iiop;
using IIOPLib;
using Ch.Elca.Iiop.Services;
using System.Collections.Generic;

public class CSClientIIOP {
    static int _x = 0;
    static int _y = 0;
    static int _orbInitialPort = 0;
    static string _orbInitialHost = "localhost";

    public static bool ParseArgs(string[] args) {
        try
        {
            int orbInitialPortIndex = Array.IndexOf(args, "-ORBInitialPort");
            int orbInitialHostIndex = Array.IndexOf(args, "-ORBInitialHost");
            int addIndex = Array.IndexOf(args, "-add");

            if (
                // have -? or -help
                (Array.IndexOf(args, "-help") != -1) ||
                (Array.IndexOf(args, "-?") != -1) ||
                // missing -ORBInitialPort or -add
                (orbInitialPortIndex == -1) ||
                (addIndex == -1)
                )
            {
                Console.WriteLine("-? -help                  print this message");
                Console.WriteLine("-ORBInitialPort <port>    nameserver port (required)");
                Console.WriteLine("-ORBInitialHost <host>    nameserver host");
                Console.WriteLine("-add <x> <y>              two numbers to add (required)");
                return false;
            }

            if (args.Length > orbInitialPortIndex + 1)
                _orbInitialPort = Convert.ToInt32(args[orbInitialPortIndex + 1]);
            if ((orbInitialHostIndex != -1) && (args.Length > orbInitialHostIndex + 1))
                _orbInitialHost = args[orbInitialHostIndex + 1];
            if (args.Length > addIndex + 2)
            {
                _x = Convert.ToInt32(args[addIndex + 1]);
                _y = Convert.ToInt32(args[addIndex + 2]);
            }
            return true;
        }
        catch (Exception e)
        {
            Console.WriteLine("Failed to parse arguments: " + e.Message);
            return false;
        }
    }


    public static void Main(string[] args) {
        try {
            if (!ParseArgs(args))
                return;

            // initialize the channel
            IiopClientChannel channel = new IiopClientChannel();
            ChannelServices.RegisterChannel(channel, false); 

            // obtain the adder references from the naming service, and call Add() on each
            CorbaInit init = CorbaInit.GetInit();
            Naming naming = new Naming(_orbInitialHost, _orbInitialPort);
            List<Ref> refs = naming.List(init);
            foreach (Ref r in refs)
            {
                MathModule.Math mathRef = (MathModule.Math)r.Obj;
                Console.Write(r.Name + ": ");
                try
                {
                    Console.WriteLine(mathRef.Add(_x, _y));
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                }
            }

        } catch (Exception e) {
            Console.WriteLine("Exception: " + e);
        }
    }
}
