package com.ociweb.JavaAddLib;

import org.omg.CORBA.UserException;

public class AddServer extends CorbaBase {
	Ref ref = null;
	
	public void shutdown() {
		try {
			if (_orb != null) {
		        Naming.unbind(_orb, ref);
				_orb.shutdown(true);
			}	
		} catch (UserException e) {
			throw new RuntimeException(e);
		}
		finally {
	        // cleanup
	        destroy();
		}
	}
	
	
	public void run(String name) {
		try {
	        // obtain a reference to the RootPOA
	        org.omg.PortableServer.POA poa =
	            org.omg.PortableServer.POAHelper.narrow(_orb.resolve_initial_references("RootPOA"));
	
	        // activate the POAManager
	        poa.the_POAManager().activate();
	
	        // create the Math servant
	        org.omg.CORBA.Object objRef = poa.servant_to_reference(new MathImpl());
			
	        // set the object reference in the name server
	        ref = new Ref(name, objRef);
	        Naming.bind(_orb, ref);
	        
	        _orb.run();
		} catch (UserException e) {
			throw new RuntimeException(e);
		}
	}
}
