package com.ociweb;

import java.util.HashMap;
import java.util.Map;

import DDS.*;
import OpenDDS.DCPS.*;
import OpenDDS.DCPS.transport.*;

import org.omg.CORBA.StringSeqHolder;

import Sensor.*;
import rx.subjects.*;

// https://github.com/ReactiveX/RxJava
// https://github.com/ReactiveX/RxJava/wiki/Creating-Observables#create
// https://github.com/ReactiveX/RxJava/wiki/Subject

public class DataReaderListenerImpl extends DDS._DataReaderListenerLocalBase {
	PublishSubject<PublishSubject<SensorData>> _obsGroup;
	Map<Integer, PublishSubject<SensorData>> _obsMap;

	public DataReaderListenerImpl(
			PublishSubject<PublishSubject<SensorData>> obsGroup) {
		_obsGroup = obsGroup;
		_obsMap = new HashMap<Integer, PublishSubject<SensorData>>();
	}

	public synchronized void on_data_available(DDS.DataReader reader) {
		SensorDataDataReader dr = SensorDataDataReaderHelper.narrow(reader);
		if (dr != null) {
			SensorDataHolder mh = new SensorDataHolder(new SensorData());
			SampleInfoHolder sih = new SampleInfoHolder(new SampleInfo(0, 0, 0,
					new DDS.Time_t(), 0, 0, 0, 0, 0, 0, 0, false));
			int status = dr.take_next_sample(mh, sih);
			if (status == RETCODE_OK.value) {

				// if instance is not found in the map, create a new observable
				// for it and push it out
				PublishSubject<SensorData> obs = null;
				if (!_obsMap.containsKey(sih.value.instance_handle)) {
					obs = PublishSubject.create();
					_obsGroup.onNext(obs);
					_obsMap.put(sih.value.instance_handle, obs);
				} else
					obs = _obsMap.get(sih.value.instance_handle);
	
				// update the observable
				if (sih.value.valid_data) {
					// data is valid - call OnNext on the observable with the data
					obs.onNext(mh.value);
				} else if (sih.value.instance_state == NOT_ALIVE_DISPOSED_INSTANCE_STATE.value) {
					// no more data - call OnCompleted on the observable
					obs.onCompleted();
				}
				
			} else {
				// can't take the sample - assume we're dead and set an error
				// state on all observables
				Exception e = new IllegalStateException();
				for (Integer k : _obsMap.keySet()) {
					_obsMap.get(k).onError(e);
				}
			}
		}
	}

	public void on_requested_deadline_missed(DDS.DataReader reader,
			DDS.RequestedDeadlineMissedStatus status) {
	}

	public void on_requested_incompatible_qos(DDS.DataReader reader,
			DDS.RequestedIncompatibleQosStatus status) {
	}

	public void on_sample_rejected(DDS.DataReader reader,
			DDS.SampleRejectedStatus status) {
	}

	public void on_liveliness_changed(DDS.DataReader reader,
			DDS.LivelinessChangedStatus status) {
	}

	public void on_subscription_matched(DDS.DataReader reader,
			DDS.SubscriptionMatchedStatus status) {
	}

	public void on_sample_lost(DDS.DataReader reader,
			DDS.SampleLostStatus status) {
	}
}
