package com.ociweb;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.Date;

import rx.subjects.*;
import rx.functions.Func1;
import rx.functions.Action1;
import rx.observers.*;
import rx.*;

public class ReactiveJ {
	static void DDS1() {
		Observable<SensorData> obs = Observable.interval(2, TimeUnit.SECONDS)
		.take(20)
		.map(new Func1<Long, SensorData>() {
		    @Override
		    public SensorData call(Long i) {
		    	return new SensorData("Temp7", new Date(), i%10);
		    }
		});
		
		obs.subscribe(new Action1<SensorData>() {
		    @Override
		    public void call(SensorData o) {
		        System.out.println("[" + o.sensorID + " " + o.date + " " + o.reading + "]");
		    }
		});		
	}
	
	
	public static void main(String[] args) throws IOException {
		DDS1();
		
		System.out.println("Press ENTER to stop");
		System.in.read();
	}
}
