#include "../SensorIDL/SensorTypeSupportImpl.h"
#include "../SensorIDL/DDSException.h"
#include <dds/DCPS/Marked_Default_Qos.h>
#include <dds/DCPS/Service_Participant.h>
#include <vcclr.h>
#include <msclr/marshal.h>

using namespace System::Collections::Generic;
using namespace System::Reactive::Subjects;
using namespace SensorEventLib;

class SensorEventPublisherSubjectImpl;

public ref class SensorEventPublisherSubject {
	SensorEventPublisherSubjectImpl *_impl;
	Subject<Subject<SensorEventArgs^>^>^ _obsGroup;
public:
	SensorEventPublisherSubject(array<System::String^>^ args, Subject<Subject<SensorEventArgs^>^>^ obsGroup);
	~SensorEventPublisherSubject();
	bool Run();
	void Stop();
};


class DataReaderListenerImpl
	: public virtual OpenDDS::DCPS::LocalObject<DDS::DataReaderListener> {
	gcroot<Subject<Subject<SensorEventArgs^>^ > ^> _obsGroup;
	gcroot<Dictionary<long, Subject<SensorEventArgs^>^>^> _obsMap;
public:
	DataReaderListenerImpl(Subject<Subject<SensorEventArgs^>^>^ obsGroup) : 
		_obsGroup(obsGroup),
		_obsMap(gcnew Dictionary<long, Subject<SensorEventArgs^>^>())
		{}

	virtual void on_requested_deadline_missed(
		DDS::DataReader_ptr reader,
		const DDS::RequestedDeadlineMissedStatus& status) {}

	virtual void on_requested_incompatible_qos(
		DDS::DataReader_ptr reader,
		const DDS::RequestedIncompatibleQosStatus& status) {}

	virtual void on_sample_rejected(
		DDS::DataReader_ptr reader,
		const DDS::SampleRejectedStatus& status) {}

	virtual void on_liveliness_changed(
		DDS::DataReader_ptr reader,
		const DDS::LivelinessChangedStatus& status) {}

	virtual void on_data_available(
		DDS::DataReader_ptr reader);

	virtual void on_subscription_matched(
		DDS::DataReader_ptr reader,
		const DDS::SubscriptionMatchedStatus& status) {}

	virtual void on_sample_lost(
		DDS::DataReader_ptr reader,
		const DDS::SampleLostStatus& status) {}
};


void DataReaderListenerImpl::on_data_available(DDS::DataReader_ptr reader) {
	try {
		DDS::SampleInfo info;
		Subject<Subject<SensorEventArgs^>^>^ obsGroup = _obsGroup;
		Dictionary<long, Subject<SensorEventArgs^>^>^ obsMap = _obsMap;
		Sensor::SensorDataDataReader_var dr =
			Sensor::SensorDataDataReader::_narrow(reader);

		if (dr) {
			Sensor::SensorData sample;
			DDS::ReturnCode_t error = dr->take_next_sample(sample, info);
			if (error == DDS::RETCODE_OK) {

				// if instance is not found in the map, create a new observable for it and push it out
				Subject<SensorEventArgs^> ^obs = nullptr;
				if (!obsMap->ContainsKey(info.instance_handle)) {
					obs = gcnew Subject<SensorEventArgs^>();
					obsGroup->OnNext(obs);
					obsMap->Add(info.instance_handle, obs);
				}
				else
					obs = obsMap[info.instance_handle];

				// update the observable
				if (info.valid_data) {
					// data is valid - call OnNext on the observable with the data
					obs->OnNext(gcnew SensorEventLib::SensorEventArgs(
						gcnew System::String(sample.sensorID),
						System::DateTime(1970, 1, 1, 0, 0, 0, System::DateTimeKind::Utc) + System::TimeSpan::FromSeconds(sample.date),
						sample.reading));
				}
				else if (info.instance_state == DDS::NOT_ALIVE_DISPOSED_INSTANCE_STATE) {
					// no more data - call OnCompleted on the observable
					obs->OnCompleted();
				}

			}
			else {
				// can't take the sample - assume we're dead and set an error state on all observables
				System::Exception ^ex = gcnew System::InvalidOperationException("take_next_sample() failed");
				for each(auto k in obsMap->Keys)
					obsMap[k]->OnError(ex);
			}
		}
	}
	catch (System::Exception ^e) {
		System::Console::WriteLine(e);
	}
}


class SensorEventPublisherSubjectImpl {
	DDS::DomainParticipantFactory_var _dpf;
	DDS::DomainParticipant_var _dp;

public:
	SensorEventPublisherSubjectImpl(array<System::String^>^ args) {
		msclr::interop::marshal_context context;
		int argc = args->Length + 1;
		char **argv = new char *[argc];
		argv[0] = "";  // don't need the program name (can't be NULL though, else ACE_Arg_Shifter fails)
		for (int i = 0; i < args->Length; i++)
			argv[i + 1] = strdup(context.marshal_as<const char*>(args[i]));

		ACE::init();  // this is necessary, else get access violations on mutex creation (guard) later

		_dpf = TheParticipantFactoryWithArgs(argc, argv);
	}

	bool Run(Subject<Subject<SensorEventArgs^>^>^ obsGroup) {
		try {
			_dp = _dpf->create_participant(42, PARTICIPANT_QOS_DEFAULT, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
			if (0 == _dp)
				throw DDSException("create_participant() failed");

			Sensor::SensorDataTypeSupport_var ts = new Sensor::SensorDataTypeSupportImpl();
			if (ts->register_type(_dp, "") != DDS::RETCODE_OK)
				throw DDSException("reigster_type() failed");

			DDS::Topic_var topic = _dp->create_topic("Temperature", ts->get_type_name(), TOPIC_QOS_DEFAULT, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
			if (0 == topic)
				throw DDSException("create_topic() failed");

			DDS::Subscriber_var sub = _dp->create_subscriber(SUBSCRIBER_QOS_DEFAULT, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
			if (0 == sub)
				throw DDSException("create_subscriber() failed");

			DDS::DataReaderQos dr_qos;
			sub->get_default_datareader_qos(dr_qos);
			DDS::DataReaderListener_var listener(new DataReaderListenerImpl(obsGroup));
			DDS::DataReader_var dr = sub->create_datareader(topic, dr_qos, listener, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
			if (0 == dr)
				throw DDSException("create_datareader() failed");

			Sensor::SensorDataDataReader_var sdr = Sensor::SensorDataDataReader::_narrow(dr);
			if (0 == sdr)
				throw DDSException("reader _narrow() failed");
		}
		catch (const std::exception &e) {
			std::cout << "SensorSubscriber exception: " << e.what() << std::endl;
			return false;
		}
		catch (const CORBA::Exception &e) {
			e._tao_print_exception("SensorSubscriber exception: ");
			return false;
		}
		catch (System::Exception ^e) {
			System::Console::WriteLine(e);
		}

		return true;
	}

	void Stop() {
		if (0 != _dp) 
			_dp->delete_contained_entities();
		if (0 != _dpf)
			_dpf->delete_participant(_dp);

		TheServiceParticipant->shutdown();

		ACE::fini();
	}

};



SensorEventPublisherSubject::SensorEventPublisherSubject(array<System::String^>^ args, Subject<Subject<SensorEventArgs^>^>^ obsGroup) :
	_impl(new SensorEventPublisherSubjectImpl(args)), _obsGroup(obsGroup) {}

SensorEventPublisherSubject::~SensorEventPublisherSubject() {
	delete _impl;
}
bool SensorEventPublisherSubject::Run() {
	return _impl->Run(_obsGroup);
}
void SensorEventPublisherSubject::Stop() {
	_impl->Stop();
}
