<?xml version="1.0" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="text"/>
    <xsl:template match="/">
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="project">

    <xsl:variable name="javaClassName">
        <xsl:value-of select="sqlJavaMap/@javaClassName"/>
    </xsl:variable>

    <xsl:variable name="sqlTableName">
        <xsl:value-of select="sqlJavaMap/@sqlTableName"/>
    </xsl:variable>

    <xsl:variable name="sqlPrimaryKey">
        <xsl:for-each select="sqlJavaMap/column">
            <xsl:if test="position()=1"><xsl:value-of
                select="@sqlColumnName"/></xsl:if>
        </xsl:for-each>
    </xsl:variable>

    <xsl:variable name="javaPrimaryKey">
        <xsl:for-each select="sqlJavaMap/column">
            <xsl:if test="position()=1"><xsl:value-of
                select="@javaVarName"/></xsl:if>
        </xsl:for-each>
    </xsl:variable>

    <xsl:variable name="primaryKeyJavaType">
        <xsl:for-each select="sqlJavaMap/column">
            <xsl:if test="position()=1"><xsl:value-of
                select="@javaTypeUpcase"/></xsl:if>
        </xsl:for-each>
    </xsl:variable>

package <xsl:value-of select="@packageName"/>;

import javax.ejb.*;
import java.rmi.*;
import java.sql.*;
import javax.sql.DataSource;
import javax.naming.*;

public class <xsl:value-of select="$javaClassName"/>Bean implements EntityBean {
    <xsl:for-each select="sqlJavaMap/column">
    public <xsl:value-of
        select="concat( @javaType,' ', @javaVarName )"/>;</xsl:for-each>

    public EntityContext context;

    <xsl:for-each select="sqlJavaMap/column">
    public <xsl:value-of select="@javaType"/> get<xsl:value-of
        select="@javaName"/>() { return <xsl:value-of
        select="@javaVarName"/>; }

    public void set<xsl:value-of
        select="@javaName"/>( <xsl:value-of
        select="@javaType"/> value ) { <xsl:value-of
        select="@javaVarName"/> = value; }
    </xsl:for-each>


    public void ejbActivate() {
    }

    public void setEntityContext( EntityContext entityContext ) {
        context = entityContext;
    }

    public void unsetEntityContext() {
        context = null;
    }

    public void ejbPassivate() {
    }

    public void ejbLoad() {
        <xsl:value-of select="$javaClassName"/>PK pk =
            (<xsl:value-of select="$javaClassName"/>PK ) context.getPrimaryKey();

        Connection con = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(<xsl:for-each
                select="sqlJavaMap/column">
            <xsl:choose><xsl:when test="position()=1">
                "select <xsl:value-of select="@sqlColumnName"/>," +</xsl:when>
            <xsl:otherwise>
                <xsl:choose><xsl:when test="position()!=last()">
                "<xsl:value-of select="@sqlColumnName"/>," +</xsl:when>
                <xsl:otherwise>
                "<xsl:value-of select="@sqlColumnName"/>" +
                " from <xsl:value-of
                    select="$sqlTableName"/> where <xsl:value-of
                    select="$sqlPrimaryKey"/> = ?" );
                </xsl:otherwise></xsl:choose></xsl:otherwise>
            </xsl:choose></xsl:for-each>

            ps.set<xsl:value-of select="$primaryKeyJavaType"/>( 1,pk.id );
            result = ps.executeQuery();
            if ( result.next() ) {
                <xsl:for-each select="sqlJavaMap/column">
                this.<xsl:value-of
                    select="@javaVarName"/> = result.get<xsl:value-of
                    select="@javaTypeUpcase"/>( "<xsl:value-of
                    select="@sqlColumnName"/>" );</xsl:for-each>

            } else {
                throw new EJBException( new ObjectNotFoundException(
                    "Cannot find Entry with id = pk.id" ));
            }
                    } catch ( SQLException se ) {
            throw new EJBException(se);
        }
        finally {
            try {
                if (result != null) result.close();
                if (ps != null) ps.close();
                if (con!= null) con.close();
            } catch(SQLException se) {
                se.printStackTrace();
            }
        }
    }

    public <xsl:value-of select="$javaClassName"/>PK ejbCreate(
            <xsl:for-each select="sqlJavaMap/column">
            <xsl:if test="position()&gt;1">,
            </xsl:if><xsl:value-of
                select="concat( @javaType,' initial', @javaName )"/></xsl:for-each> )
                throws CreateException {
        <xsl:for-each select="sqlJavaMap/column">
        this.<xsl:value-of
            select="concat( @javaVarName,' = initial',@javaName)"/>;</xsl:for-each>

        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(
                "insert into <xsl:value-of
                    select="$sqlTableName"/> (" +<xsl:for-each
                    select="sqlJavaMap/column">
            <xsl:choose><xsl:when test="position()&lt;last()">
                    "<xsl:value-of select="@sqlColumnName"/>, " +</xsl:when>
            <xsl:otherwise>
                    "<xsl:value-of select="@sqlColumnName"/>" +</xsl:otherwise>
            </xsl:choose></xsl:for-each>
                    ") values ( ?, ?, ?, ? )" );
            <xsl:for-each select="sqlJavaMap/column">
            ps.set<xsl:value-of select="@javaTypeUpcase"/>( <xsl:value-of
                select="position()"/>, this.<xsl:value-of
                select="@javaVarName"/> );</xsl:for-each>

            if ( ps.executeUpdate() != 1 ) {
                throw new CreateException( "Failed to add <xsl:value-of
                    select="$javaClassName"/> to database." );
            }

            <xsl:value-of
                select="$javaClassName"/>PK pk = new <xsl:value-of
                select="$javaClassName"/>PK();
            pk.id = auctionId;
            return pk;

        }
        catch (SQLException se) {
            throw new EJBException(se);
        }
        finally {
            try {
                if ( ps != null ) ps.close();
                if ( con!= null ) con.close();
            } catch( SQLException se ){
                se.printStackTrace();
            }
        }
    }

    public void ejbPostCreate(
            <xsl:for-each select="sqlJavaMap/column">
            <xsl:if test="position()&gt;1">,
            </xsl:if><xsl:value-of
                select="concat( @javaType,' initial',@javaName )"/></xsl:for-each> ) {
        // Do something useful with the primary key.
    }

    public <xsl:value-of
        select="$javaClassName"/>PK ejbFindByPrimaryKey( <xsl:value-of
        select="$javaClassName"/>PK pk )
            throws FinderException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(
                "select <xsl:value-of
                    select="$sqlPrimaryKey"/> from <xsl:value-of
                    select="$sqlTableName"/> where <xsl:value-of
                    select="$sqlPrimaryKey"/> = ?");
            ps.set<xsl:value-of select="$primaryKeyJavaType"/>( 1, pk.id );
            result = ps.executeQuery();
            if ( !result.next() ) {
                throw new ObjectNotFoundException(
                    "Cannot find <xsl:value-of
                        select="$javaClassName"/> with id = " + pk.id );
            }
        } catch( SQLException se ) {
            throw new EJBException(se);
        }
        finally {
            try {
                if ( result != null) result.close();
                if ( ps != null) ps.close();
                if ( con!= null) con.close();
            } catch( SQLException se ) {
                se.printStackTrace();
            }
        }
        return pk;
    }

    public void ejbStore() {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(
                "update <xsl:value-of
                    select="$sqlTableName"/> set " +<xsl:for-each
                        select="sqlJavaMap/column">
                <xsl:choose><xsl:when test="position()&lt;last()">
                    "<xsl:value-of
                        select="@sqlColumnName"/> = ?, " +</xsl:when>
                    <xsl:otherwise>
                    "<xsl:value-of
                        select="@sqlColumnName"/> = ? " +
                "where <xsl:value-of
                    select="$sqlPrimaryKey"/> = ?" );</xsl:otherwise>
                </xsl:choose></xsl:for-each>

            <xsl:for-each select="sqlJavaMap/column">
            ps.set<xsl:value-of select="@javaTypeUpcase"/>( <xsl:value-of
                select="position()"/>, this.<xsl:value-of
                    select="@javaVarName"/> );</xsl:for-each>

            if (ps.executeUpdate() != 1) {
                    throw new EJBException("ejbStore failed" );
            }
        }
        catch (SQLException se) {
            throw new EJBException(se);
        }
        finally {
            try {
                if ( ps != null ) ps.close();
                if ( con!= null ) con.close();
            } catch( SQLException se ){
                se.printStackTrace();
            }
        }
    }

    public void ejbRemove() {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement("delete from <xsl:value-of
                select="$sqlTableName"/> where <xsl:value-of
                select="$sqlPrimaryKey"/> = ?" );
            ps.set<xsl:value-of
                select="$primaryKeyJavaType"/>( 1, this.<xsl:value-of
                select="$javaPrimaryKey"/> );
            if ( ps.executeUpdate() != 1 ) {
                throw new EJBException("remove failed");
            }
        }
        catch( SQLException se ) {
            throw new EJBException( se );
        }
        finally {
            try {
                if ( ps != null ) ps.close();
                if ( con!= null ) con.close();
            } catch( SQLException se ){
                se.printStackTrace();
            }
        }
    }

    private Connection getConnection() throws SQLException {
        try {
            Context jndiCntx = new InitialContext();
            DataSource ds =
                (DataSource)jndiCntx.lookup("java:comp/env/jdbc/xmedbook");
            return ds.getConnection();
        }
        catch ( NamingException ne ) {
            throw new EJBException( ne );
        }
    }


}
    </xsl:template>
</xsl:stylesheet>

