<?xml version="1.0" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="text"/>

    <xsl:template match="/">
        <xsl:apply-templates mode="javaClass"/>
    </xsl:template>

    <xsl:template match="project" mode="javaClass">

    <xsl:variable name="javaClassName">
        <xsl:value-of select="sqlJavaMap/@javaClassName"/>
    </xsl:variable>

    <xsl:variable name="sqlTableName">
        <xsl:value-of select="sqlJavaMap/@sqlTableName"/>
    </xsl:variable>

    <xsl:variable name="sqlPrimaryKey">
        <xsl:for-each select="sqlJavaMap/column">
            <xsl:if test="position()=1"><xsl:value-of select="@sqlColumnName"/></xsl:if>
        </xsl:for-each>
    </xsl:variable>

    <xsl:variable name="javaPrimaryKey">
        <xsl:for-each select="sqlJavaMap/column">
            <xsl:if test="position()=1"><xsl:value-of select="@javaVarName"/></xsl:if>
        </xsl:for-each>
    </xsl:variable>

    <xsl:variable name="primaryKeyJavaType">
        <xsl:for-each select="sqlJavaMap/column">
            <xsl:if test="position()=1"><xsl:value-of select="@javaTypeUpcase"/></xsl:if>
        </xsl:for-each>
    </xsl:variable>

package <xsl:value-of select="@packageName"/>;

import java.rmi.*;
import java.util.*;
import javax.ejb.*;
import java.sql.Timestamp;

public interface <xsl:value-of select="$javaClassName"/>Home extends EJBHome {

    <xsl:value-of select="$javaClassName"/> create( <xsl:for-each
        select="sqlJavaMap/column">
            <xsl:if test="position()&gt;1">,
            </xsl:if><xsl:value-of
                select="@javaType"/><xsl:text> </xsl:text>initial<xsl:value-of
                select="@javaName"/></xsl:for-each> )
        throws RemoteException, CreateException;

    public <xsl:value-of
                select="$javaClassName"/> findByPrimaryKey( <xsl:value-of
                select="$javaClassName"/>PK primaryKey )
        throws FinderException, RemoteException;

}
    </xsl:template>
</xsl:stylesheet>

