<?xml version="1.0" encoding="UTF-8"?>
<!--
This stylesheet removes images from an XHTML document and replaces them
with links (<a href="....).
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

	<!-- Replace img element with link -->	
	<xsl:template match="img">
    	<a href="{@src}">View <xsl:value-of select="@src"/></a>
  	</xsl:template>
  
  <!--
  This is the identity transformation.
  It copies any attributes, elements, text nodes, comments and
  processing instructions in the source document to the result document.
  -->
  <xsl:template match="*|@*|text()|comment()|processing-instruction()">
    <xsl:copy>
      <!-- Picks up everything, including attributes -->
      <xsl:apply-templates select="*|@*|text()|comment()|processing-instruction()"/>
      <!-- Do the following to process all child nodes except attributes -->
      <!--<xsl:apply-templates/>-->
    </xsl:copy>
  </xsl:template>
            
</xsl:stylesheet>