import java.io.*;
import java.util.*;

public class CourseCatalog implements Serializable {
    private static CourseCatalogEntry[] entries;
    private static Map courses = new HashMap();

    static {
        // first make up a bunch of fake courses
        // (in a real web app, you would get these from a database)
        Course c = new Course("javaprog", "Java Programming",
                "Learn how to write Java applications and applets.",
                "lecture_lab", 3, new String[] {
                    "Language Syntax", "OO Concepts", "Operators",
                    "Looping", "Applets", "AWT GUI", "Exception Handling" });
        courses.put(c.getId(), c);

        c = new Course("javasyntax", "Java Syntax",
                "Basic language syntax for non-C programmers.",
                "lecture_lab", 2, new String[] {
                    "Language Syntax", "Operators", "Looping", 
                    "Command Line Parameters", "JDK Tools" });
        courses.put(c.getId(), c);

        c = new Course("advjava", "Advanced Java",
                "Coverage of advanced language topics.",
                "lecture_lab", 3, new String[] {
                    "RMI", "JDBC", "JNI", "Threading", "Sockets",
                    "Reflection", "Inner Classes" });
        courses.put(c.getId(), c);

        Collection courseSet = courses.values();
        entries = new CourseCatalogEntry[courseSet.size()];
        int curPos = 0;
        Iterator iter = courseSet.iterator();
        while (iter.hasNext()) {
            Course curCourse = (Course) iter.next();
            entries[curPos++] = new CourseCatalogEntry(
                    curCourse.getId(), curCourse.getTitle());
        }
    }

    public static CourseCatalogEntry[] getCourses() {
        return entries;
    }

    public static Course getCourse(String courseId) {
        return (Course) courses.get(courseId);
    }
}
