<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="/">
		<html>
			<head>
				<title>Course Details</title>
			</head>
			<body>
				<xsl:apply-templates select="course"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="course">
		<h1>Course Details</h1>
		<a href=".">Return to the course catalog...</a><p/>
		<table border="1" cellpadding="4" cellspacing="0">
			<tr valign="top">
				<td>Title:</td>
				<td>
					<xsl:value-of select="title"/>
				</td>
			</tr>
			<tr valign="top">
				<td>Duration:</td>
				<td>
					<xsl:value-of select="days"/> Days</td>
			</tr>
			<tr valign="top">
				<td>Format:</td>
				<td>
					<xsl:choose>
						<xsl:when test="format/@type='lecture_lab'">Lecture / Lab</xsl:when>
					</xsl:choose>
				</td>
			</tr>
			<tr valign="top">
				<td>Overview</td>
				<td>
					<xsl:value-of select="overview"/>
				</td>
			</tr>
			<tr valign="top">
				<td>Topics</td>
				<td>
					<ul>
						<xsl:apply-templates select="topics/topic"/>
					</ul>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	  ************************************************************
	  A template to display an individual topic as a bullet point
	  ************************************************************
	  -->
	<xsl:template match="topic">
		<li>
			<xsl:value-of select="."/>
		</li>
	</xsl:template>
</xsl:stylesheet>
