import java.io.*;
import javax.servlet.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.apache.xalan.xslt.*;

/**
 * A custom action which allows the content of a tag, which contains
 * well-formed XML, to be converted to HTML using an XSLT stylesheet.
 */
public class XmlXsltTag extends BodyTagSupport {
    private String xsltLocation = "";

    public int doAfterBody() throws JspException {
        try {
            // the content of the custom tag contains the XML source
            XSLTInputSource xmlSource = new XSLTInputSource(
                    bodyContent.getReader());

            // locate the XSLT stylesheet
            ServletContext sc = pageContext.getServletContext();
            XSLTInputSource stylesheet = new XSLTInputSource(
                    sc.getResourceAsStream(xsltLocation));

            // prepare to write the resulting HTML back to the browser
            JspWriter out = getPreviousOut();
            XSLTResultTarget resultTree = new XSLTResultTarget(out);

            XSLTProcessor processor = XSLTProcessorFactory.getProcessor();
            processor.process(xmlSource, stylesheet, resultTree);

            // inform JSP that it does not need to continue processing 
            // the body of this custom tag
            return Tag.SKIP_BODY;
        } catch (org.xml.sax.SAXException saxEx) {
            throw new JspException("SAXException: " + saxEx.getMessage());
        }
    }

    /**
     * A setter method for the "xsltLocation" attribute
     */
    public void setXsltLocation(String xsltLocation) {
        this.xsltLocation = xsltLocation;
    }

    /**
     * A getter method for the "xsltLocation" attribute
     */
    public String getXsltLocation() {
        return this.xsltLocation;
    }

    /**
     * Reset the state of this object to default values in case
     * JSP reuses the instance.
     */
    public void release() {
        super.release();
        this.xsltLocation = "";
    }
}

