import java.io.*;

public class Course implements Serializable {
    private String id, title, overview, formatCode;
    private int numDays;
    private String[] topics;

    public Course() {
        this("", "", "", "", 0, new String[0]);
    }

    public Course(String id, String title, String overview, 
            String formatCode, int numDays, String[] topics) {
        this.id = id;
        this.title = title;
        this.overview = overview;
        this.formatCode = formatCode;
        this.numDays = numDays;
        this.topics = topics;
    }

    public void setId(String id) {
        this.id = id;
        populateFromDatabase(); // look up the remaining values
    }

    public String getId() { return id; }
    public String getTitle() { return title; }
    public String getOverview() { return overview; }
    public String getFormatCode() { return formatCode; }
    public int getNumDays() { return numDays; }
    public String[] getTopics() { return topics; }


    private void populateFromDatabase() {
        Course c = CourseCatalog.getCourse(id);
        if (c != null) {
            this.title = c.title;
            this.overview = c.overview;
            this.formatCode = c.formatCode;
            this.numDays = c.numDays;
            this.topics = c.topics;
        } else {
            this.title = "";
            this.overview = "";
            this.formatCode = "";
            this.numDays = 0;
            this.topics = new String[0];
        }
    }
}
