package oci.db;

import org.apache.log4j.Logger;

/**
 *
 * @author  Mario Aquino (OCI)
 */
public class DBHelperException extends java.lang.Exception {
    private static Logger log = Logger.getLogger(DBHelperException.class);
    /**
     * Creates a new instance of <code>DBHelperException</code> without detail message.
     */
    public DBHelperException(String msg) {
        super(msg);
        log.warn(msg, this);
    }
    
    
    /**
     * Constructs an instance of <code>DBHelperException</code> with the specified detail message.
     * @param msg the detail message.
     */
    public DBHelperException(String msg, Throwable cause) {
        super(msg, cause);
        log.warn(msg, this);
    }
    
    public DBHelperException(Throwable cause) {
        super(cause);
        log.warn("", this);
    }
}
