<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema">
<xsl:output method="xml" indent="yes" encoding="UTF-8" version="1.0"/>

<xsl:template match="/">
	<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema">
	<xsl:apply-templates select="//tables//TABLE_NAME"/>
	</xs:schema>
</xsl:template>

<xsl:template match="TABLE_NAME">
	<xsl:variable name="tableName" select="."/>
	<xs:element>
		<xsl:attribute name="name"><xsl:value-of select="$tableName"/></xsl:attribute>
		<xs:complexType>
			<xs:sequence>
				<xsl:apply-templates select="//columns//COLUMN_NAME[preceding-sibling::TABLE_NAME=$tableName]"/>
			</xs:sequence>		
		</xs:complexType>
		<xsl:apply-templates select="//primarykeys//pk_name[preceding-sibling::table_name=$tableName]"/>
		<xsl:apply-templates select="//importedkeys//FK_NAME[preceding-sibling::FKTABLE_NAME=$tableName]"/>
	</xs:element>
</xsl:template>

<xsl:template match="COLUMN_NAME">
	<xsl:variable name="columnName" select="."/>
	<xsl:variable name="datatype" select="$columnName/following-sibling::DATA_TYPE"/>        
	<xs:element>
		<xsl:attribute name="name"><xsl:value-of select="$columnName"/></xsl:attribute>        
         <xsl:choose>
            <xsl:when test="$datatype='Varchar'">
                <xs:simpleType>
                    <xs:restriction base="xs:string">
                        <xs:maxLength value="{$datatype/following-sibling::COLUMN_SIZE}"/>
                    </xs:restriction>                
                </xs:simpleType>
            </xsl:when>
            <xsl:otherwise>            
                <xsl:attribute name="type">
                    <xsl:choose>
                        <xsl:when test="$datatype='BigInt'">xs:long</xsl:when>
                        <xsl:when test="$datatype='Boolean'">xs:boolean</xsl:when>
                        <xsl:when test="$datatype='Date'">xs:date</xsl:when>
                        <xsl:when test="$datatype='Timestamp'">xs:dateTime</xsl:when>
                        <xsl:when test="$datatype='Double'">xs:double</xsl:when>
                        <xsl:when test="$datatype='Float'">xs:float</xsl:when>
                        <xsl:when test="$datatype='Integer'">xs:int</xsl:when>
                        <xsl:when test="$datatype='Time'">xs:time</xsl:when>
                        <xsl:when test="$datatype='TinyInt'">xs:short</xsl:when>                        		
                        <xsl:otherwise>xs:any</xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
           </xsl:otherwise>
        </xsl:choose>
	</xs:element>
</xsl:template>

<xsl:template match="pk_name">
	<xsl:variable name="primaryKey" select="."/>
	<xs:key>
		<xsl:attribute name="name"><xsl:value-of select="$primaryKey"/></xsl:attribute>
		<xs:selector>
			<xsl:attribute name="xpath">.</xsl:attribute>
		</xs:selector>
		<xs:field>
			<xsl:attribute name="xpath">
				<xsl:value-of select="$primaryKey/preceding-sibling::column_name"/>
			</xsl:attribute>
		</xs:field>
	</xs:key>
</xsl:template>

<xsl:template match="FK_NAME">
	<xsl:variable name="foreignKey" select="."/>
	<xs:keyref>
		<xsl:attribute name="name">
			<xsl:value-of select="$foreignKey"/>
		</xsl:attribute>
		<xsl:attribute name="refer">
			<xsl:value-of select="$foreignKey/following-sibling::PK_NAME"/>
		</xsl:attribute>
		<xs:selector>
			<xsl:attribute name="xpath">.</xsl:attribute>
		</xs:selector>
		<xs:field>
			<xsl:attribute name="xpath">
				<xsl:value-of select="$foreignKey/preceding-sibling::FKCOLUMN_NAME"/>
			</xsl:attribute>
		</xs:field>
	</xs:keyref>
</xsl:template>
</xsl:stylesheet>
