package oci.db;

import java.sql.*;
import java.util.*;
import org.apache.log4j.Logger;

/**
 * This is a Database Connection Manager class responsible for attaining
 * connections to a datasource and managing them in a reusable pool.
 * @author  Mario Aquino
 */
public class DBConnMgr {
    private static Logger log = Logger.getLogger(DBConnMgr.class);
    private static DBConnMgr instance;
    private Connection conn;
    
    //This should be done with a configuration file to indicate db driver specifics
    //but for the purposes of a demo, this is fine.
    private static String DATABASE_DRIVER;
    private static String URL;
    private static String USERNAME;
    private static String PASSWORD;
    
    static {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("dbconnmgr");
            DATABASE_DRIVER = rb.getString("db.driver");
            URL = rb.getString("db.url");
            USERNAME = rb.getString("db.username");
            PASSWORD = rb.getString("db.password");
            
            log.debug("Loading dB driver.");
            Class.forName(DATABASE_DRIVER);
            log.debug("dB driver loaded.");
        } catch (Exception cnfe) {
            log.warn("Exception thrown in static initializer", cnfe);
            System.exit(1);
        }            
    }
    
    /** Creates a new instance of DBConnMgr */
    private DBConnMgr() {
    }    
    
    private void establishConnection() throws SQLException {
        //This should be done with a configuration file to properly manage the
        //size of the pool, but for demo purposes, hardcode a poolsize of 1
        //is fine.
        try {
            if ((conn == null)||(conn.isClosed())) {
                log.debug("Attempting to connect to DB...");
                conn = DriverManager.getConnection(URL, USERNAME, PASSWORD);
                log.debug("DB Connection established.");
            }
        } catch (SQLException e) {
            log.error("Establish Connection Error: Connection cannot be established", e);
            throw e;
        }
    }
    
    /**
     * This is the Singleton accessor for the <code>DBConnMgr</code> instance.
     * @return The instance of the <code>DBConnMgr</code>
     */
    public static DBConnMgr getInstance() {
        if (instance == null) {
            synchronized(DBConnMgr.class) {
                if (instance == null)
                    instance = new DBConnMgr();
            }
        }
        return instance;
    }
    
    /**
     * This method returns a database <code>Connection</code> object from the pool.
     * @return A <code>Connection</code> object to a database.
     */
    public Connection getConnection() throws SQLException {
        establishConnection();
        return conn;
    }
    
    /**
     * This method returns a <code>Connection</code> instance to the pool
     * @param conn A <code>Connection</code> object to be returned to the pool
     */
    public void freeConnection(Connection conn) {
        
    }    
}
