package com.ociweb.jnb.ex1;

import java.util.Properties;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.lang.reflect.Proxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class TransactionManager {
    private static final String PROPERTIES_NAME = "TransactionManager.properties";
    private static final String DB_DRIVER;
    private static final String DB_URL;
    private static final String USERNAME;
    private static final String PASSWORD;

    private Connection conn;
    private Connection proxy;

    private static TransactionManager instance;

    static {
        Properties props = new Properties();
        try {
            props.load(TransactionManager.class.getResourceAsStream(PROPERTIES_NAME));
        } catch (IOException e) {
            e.printStackTrace();
        }
        DB_DRIVER = props.getProperty("DB_DRIVER");
        DB_URL = props.getProperty("DB_URL");
        USERNAME = props.getProperty("USERNAME");
        PASSWORD = props.getProperty("PASSWORD");

        try {
            Class.forName(DB_DRIVER).newInstance();
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }

        instance = new TransactionManager();
    }

    private TransactionManager() {
        initialize();
    }

    private void initialize() {
        //Connect to database
        try {
            conn = DriverManager.getConnection(DB_URL, USERNAME, PASSWORD);
            conn.setAutoCommit(false);
            proxy = createConnectionProxy();
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static TransactionManager getInstance() {
        return instance;
    }

    public void commit() throws TransactionException {
        try {
            conn.commit();
        } catch (SQLException e) {
            throw new TransactionException(e);
        }
    }

    public void rollback() throws TransactionException {
        try {
            conn.rollback();
        } catch (SQLException e) {
            throw new TransactionException(e);
        }
    }

    public Connection getConnection() {
        return proxy;
    }

    private Connection createConnectionProxy() {
        return (Connection) Proxy.newProxyInstance(
                getClass().getClassLoader(), new Class[]{Connection.class}, new ConnectionProxy(conn));
    }

    private static class ConnectionProxy implements InvocationHandler {
        private Connection delegate;

        ConnectionProxy(Connection delegate) {
            this.delegate = delegate;
        }

        public Object invoke(Object proxy, Method method, Object[] args)
                throws Throwable {
            if (method.getName().equalsIgnoreCase("commit")) {
                return null;
            } else if (method.getName().equalsIgnoreCase("rollback")) {
                return null;
            }
            return method.invoke(delegate, args);
        }
    }
}
