package com.ociweb.jnb.ex3;

import java.util.Properties;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.lang.reflect.Proxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class TransactionManagerImpl implements TransactionManager {
    private static final String PROPERTIES_NAME = "TransactionManager.properties";
    private static String DB_DRIVER;
    private static String DB_URL;
    private static String USERNAME;
    private static String PASSWORD;

    private Connection conn;
    private Connection proxy;

    public TransactionManagerImpl(ConnectionFactory connectionFactory) {
        initialize(connectionFactory);
    }

    private void initialize(ConnectionFactory connectionFactory) {
        try {
            Properties  props = GlobalPropertiesManager.get().loadProperties(PROPERTIES_NAME);
            DB_DRIVER = props.getProperty("DB_DRIVER");
            DB_URL = props.getProperty("DB_URL");
            USERNAME = props.getProperty("USERNAME");
            PASSWORD = props.getProperty("PASSWORD");
        } catch (IOException e) {
            e.printStackTrace();
        }

        //Connect to database
        try {
            conn = connectionFactory.createConnection(DB_DRIVER, DB_URL, USERNAME, PASSWORD);
            conn.setAutoCommit(false);
            proxy = createConnectionProxy();
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void commit() throws TransactionException {
        try {
            conn.commit();
        } catch (SQLException e) {
            throw new TransactionException(e);
        }
    }

    public void rollback() throws TransactionException {
        try {
            conn.rollback();
        } catch (SQLException e) {
            throw new TransactionException(e);
        }
    }

    public Connection getConnection() {
        return proxy;
    }

    private Connection createConnectionProxy() {
        return (Connection) Proxy.newProxyInstance(
                getClass().getClassLoader(), new Class[]{Connection.class}, new ConnectionProxy(conn));
    }

    private static class ConnectionProxy implements InvocationHandler {
        private Connection delegate;

        ConnectionProxy(Connection delegate) {
            this.delegate = delegate;
        }

        public Object invoke(Object proxy, Method method, Object[] args)
                throws Throwable {
            if (method.getName().equalsIgnoreCase("commit")) {
                return null;
            } else if (method.getName().equalsIgnoreCase("rollback")) {
                return null;
            }
            return method.invoke(delegate, args);
        }
    }
}
