/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.lang;

import com.mchange.v1.jvm.InternalNameUtils;
import com.mchange.v1.jvm.TypeFormatException;
import com.mchange.v1.lang.AmbiguousClassNameException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ClassUtils {
    static final String[] EMPTY_SA = new String[0];
    static Map primitivesToClasses;

    public static Set allAssignableFrom(Class type) {
        HashSet out = new HashSet();
        Class cl = type;
        while (cl != null) {
            out.add(cl);
            cl = cl.getSuperclass();
        }
        ClassUtils.addSuperInterfacesToSet(type, out);
        return out;
    }

    public static String simpleClassName(Class cl) {
        try {
            String out = ClassUtils.simpleClassName(cl.getName());
            if (cl.isArray()) {
                out = InternalNameUtils.decodeType(out);
            }
            return out;
        }
        catch (TypeFormatException e) {
            e.printStackTrace();
            throw new InternalError("Huh? the name of a genuine type failed to decode!");
        }
    }

    private static String simpleClassName(String fqcn) {
        int pkgdot = fqcn.lastIndexOf(46);
        if (pkgdot < 0) {
            return fqcn;
        }
        String scn = fqcn.substring(pkgdot + 1);
        if (scn.indexOf(36) >= 0) {
            StringBuffer sb = new StringBuffer(scn);
            int i = 0;
            int len = sb.length();
            while (i < len) {
                if (sb.charAt(i) == '$') {
                    sb.setCharAt(i, '.');
                }
                ++i;
            }
            return sb.toString();
        }
        return scn;
    }

    public static boolean isPrimitive(String typeStr) {
        return primitivesToClasses.get(typeStr) != null;
    }

    public static Class classForPrimitive(String typeStr) {
        return (Class)primitivesToClasses.get(typeStr);
    }

    public static Class classForSimpleName(String simpleName, String[] importPkgs, String[] importClasses) throws AmbiguousClassNameException, ClassNotFoundException {
        HashSet<String> checkSet = new HashSet<String>();
        Class<?> out = ClassUtils.classForPrimitive(simpleName);
        if (out == null) {
            if (importPkgs == null) {
                importPkgs = EMPTY_SA;
            }
            if (importClasses == null) {
                importClasses = EMPTY_SA;
            }
            int i = 0;
            int len = importClasses.length;
            while (i < len) {
                String importSimpleName = ClassUtils.fqcnLastElement(importClasses[i]);
                if (!checkSet.add(importSimpleName)) {
                    throw new IllegalArgumentException("Duplicate imported classes: " + importSimpleName);
                }
                if (simpleName.equals(importSimpleName)) {
                    out = Class.forName(importClasses[i]);
                }
                ++i;
            }
            if (out == null) {
                try {
                    out = Class.forName("java.lang." + simpleName);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                int i2 = 0;
                int len2 = importPkgs.length;
                while (i2 < len2) {
                    block14: {
                        try {
                            String tryClass = importPkgs[i2] + '.' + simpleName;
                            Class<?> test = Class.forName(tryClass);
                            if (out == null) {
                                out = test;
                                break block14;
                            }
                            throw new AmbiguousClassNameException(simpleName, out, test);
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                    ++i2;
                }
            }
        }
        if (out == null) {
            throw new ClassNotFoundException("Could not find a class whose unqualified name is \"" + simpleName + "\" with the imports supplied.");
        }
        return out;
    }

    public static String resolvableTypeName(Class type, String[] importPkgs, String[] importClasses) throws ClassNotFoundException {
        String simpleName = ClassUtils.simpleClassName(type);
        try {
            ClassUtils.classForSimpleName(simpleName, importPkgs, importClasses);
        }
        catch (AmbiguousClassNameException e) {
            return type.getName();
        }
        return simpleName;
    }

    public static String fqcnLastElement(String fqcn) {
        int pkgdot = fqcn.lastIndexOf(46);
        if (pkgdot < 0) {
            return fqcn;
        }
        return fqcn.substring(pkgdot + 1);
    }

    private static void addSuperInterfacesToSet(Class type, Set set) {
        Class<?>[] ifaces = type.getInterfaces();
        int i = 0;
        int len = ifaces.length;
        while (i < len) {
            set.add(ifaces[i]);
            ClassUtils.addSuperInterfacesToSet(ifaces[i], set);
            ++i;
        }
    }

    private ClassUtils() {
    }

    static {
        HashMap<String, Class<Object>> tmp = new HashMap<String, Class<Object>>();
        tmp.put("boolean", Boolean.TYPE);
        tmp.put("int", Integer.TYPE);
        tmp.put("char", Character.TYPE);
        tmp.put("short", Short.TYPE);
        tmp.put("int", Integer.TYPE);
        tmp.put("long", Long.TYPE);
        tmp.put("float", Float.TYPE);
        tmp.put("double", Double.TYPE);
        tmp.put("void", Void.TYPE);
        primitivesToClasses = Collections.unmodifiableMap(tmp);
    }
}

