/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.lang.ObjectUtils;
import com.mchange.v2.ser.SerializableUtils;
import com.mchange.v2.ser.UnsupportedVersionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public abstract class DriverManagerDataSource
implements DataSource,
Referenceable {
    static final Coalescer IMMUTABLES_COALESCER = CoalescerFactory.createCoalescer(true, true);
    transient String driverClass;
    transient String jdbcUrl;
    transient Properties properties = new Properties();
    transient String description;
    transient String factoryClassLocation;
    static final String REFADDR_VERSION = "version";
    static final String REFADDR_driverClass = "driverClass";
    static final String REFADDR_jdbcUrl = "jdbcUrl";
    static final String REFADDR_properties = "properties";
    static final String REFADDR_description = "description";
    static final int CURRENT_VERSION = 1;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$ObjectFactory;

    String getDriverClass() {
        return this.driverClass;
    }

    String getJdbcUrl() {
        return this.jdbcUrl;
    }

    Properties getProperties() {
        return (Properties)((Hashtable)this.properties).clone();
    }

    String getDescription() {
        return this.description;
    }

    String getUser() {
        return this.properties.getProperty("user");
    }

    String getPassword() {
        return this.properties.getProperty("password");
    }

    String getFactoryClassLocation() {
        return this.factoryClassLocation;
    }

    void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        this._realizeDriverClass();
    }

    void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    void setProperties(Properties properties) {
        this.properties = properties = (Properties)((Hashtable)properties).clone();
    }

    void setDescription(String description) {
        this.description = description;
    }

    void setUser(String user) {
        this._setUser(user);
    }

    void setPassword(String password) {
        this._setPassword(password);
    }

    void setFactoryClassLocation(String factoryClassLocation) {
        this.factoryClassLocation = factoryClassLocation;
    }

    public Immutable asImmutable() {
        return Immutable.find(this.driverClass, this.jdbcUrl, this.properties, this.description, this.factoryClassLocation);
    }

    public final Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.jdbcUrl, this.properties);
    }

    public final Connection getConnection(String username, String password) throws SQLException {
        return DriverManager.getConnection(this.jdbcUrl, this.overrideProps(username, password));
    }

    public final PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public final void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    public final int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    public final void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    private void _setUser(String user) {
        if (user != null) {
            ((Hashtable)this.properties).put("user", user);
        } else {
            ((Hashtable)this.properties).remove("user");
        }
    }

    private void _setPassword(String password) {
        if (password != null) {
            ((Hashtable)this.properties).put("password", password);
        } else {
            ((Hashtable)this.properties).remove("password");
        }
    }

    private final Properties overrideProps(String user, String password) {
        Properties overriding = (Properties)((Hashtable)this.properties).clone();
        ((Hashtable)overriding).put("user", user);
        ((Hashtable)overriding).put("password", password);
        return overriding;
    }

    void _realizeDriverClass() {
        try {
            if (this.driverClass != null) {
                Class.forName(this.driverClass);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean parseBoolean(String sRep) {
        return Boolean.valueOf(sRep);
    }

    private static char firstChar(String s) {
        return s.charAt(0);
    }

    public final Reference getReference() throws NamingException {
        try {
            Reference out = new Reference((class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable = DriverManagerDataSource.class$("com.mchange.v2.c3p0.impl.DriverManagerDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable).getName(), (class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$ObjectFactory == null ? (class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$ObjectFactory = DriverManagerDataSource.class$("com.mchange.v2.c3p0.impl.DriverManagerDataSource$ObjectFactory")) : class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$ObjectFactory).getName(), this.factoryClassLocation);
            out.add(new StringRefAddr(REFADDR_VERSION, String.valueOf(1)));
            out.add(new StringRefAddr(REFADDR_driverClass, this.driverClass));
            out.add(new StringRefAddr(REFADDR_jdbcUrl, this.jdbcUrl));
            out.add(new BinaryRefAddr(REFADDR_properties, SerializableUtils.toByteArray(this.properties)));
            out.add(new StringRefAddr(REFADDR_description, this.description));
            return out;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NamingException("Nested Exception: " + e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class Mutable
    extends DriverManagerDataSource
    implements Serializable {
        public synchronized String getDriverClass() {
            return super.getDriverClass();
        }

        public synchronized String getJdbcUrl() {
            return super.getJdbcUrl();
        }

        public synchronized Properties getProperties() {
            return super.getProperties();
        }

        public synchronized String getDescription() {
            return super.getDescription();
        }

        public synchronized String getUser() {
            return super.getUser();
        }

        public synchronized String getPassword() {
            return super.getPassword();
        }

        public synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public synchronized void setDriverClass(String driverClass) {
            super.setDriverClass(driverClass);
        }

        public synchronized void setJdbcUrl(String jdbcUrl) {
            super.setJdbcUrl(jdbcUrl);
        }

        public synchronized void setProperties(Properties properties) {
            super.setProperties(properties);
        }

        public synchronized void setDescription(String description) {
            super.setDescription(description);
        }

        public synchronized void setUser(String user) {
            super.setUser(user);
        }

        public synchronized void setPassword(String password) {
            super.setPassword(password);
        }

        public synchronized void setFactoryClassLocation(String factoryClassLocation) {
            super.setFactoryClassLocation(factoryClassLocation);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of DriverManagerDataSource");
        }

        private void readObject(ObjectInputStream in) throws IOException {
            throw new IOException("We should not be finding this mutable version of DriverManagerDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static abstract class Base
    extends DriverManagerDataSource
    implements Serializable {
        protected synchronized String getDriverClass() {
            return super.getDriverClass();
        }

        protected synchronized String getJdbcUrl() {
            return super.getJdbcUrl();
        }

        protected synchronized Properties getProperties() {
            return super.getProperties();
        }

        protected synchronized String getDescription() {
            return super.getDescription();
        }

        protected synchronized String getUser() {
            return super.getUser();
        }

        protected synchronized String getPassword() {
            return super.getPassword();
        }

        protected synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        protected synchronized void setDriverClass(String driverClass) {
            super.setDriverClass(driverClass);
        }

        protected synchronized void setJdbcUrl(String jdbcUrl) {
            super.setJdbcUrl(jdbcUrl);
        }

        protected synchronized void setProperties(Properties properties) {
            super.setProperties(properties);
        }

        protected synchronized void setDescription(String description) {
            super.setDescription(description);
        }

        protected synchronized void setUser(String user) {
            super.setUser(user);
        }

        protected synchronized void setPassword(String password) {
            super.setPassword(password);
        }

        protected synchronized void setFactoryClassLocation(String factoryClassLocation) {
            super.setFactoryClassLocation(factoryClassLocation);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of DriverManagerDataSource");
        }

        private void readObject(ObjectInputStream in) throws IOException {
            throw new IOException("We should not be finding this mutable version of DriverManagerDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static final class Immutable
    extends DriverManagerDataSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final short VERSION = 1;

        public static Immutable find(String _driverClass, String _jdbcUrl, Properties _properties, String _description, String _factoryClassLocation) {
            Immutable uncanonical = new Immutable();
            uncanonical.driverClass = _driverClass;
            uncanonical._realizeDriverClass();
            uncanonical.jdbcUrl = _jdbcUrl;
            uncanonical.properties = _properties;
            uncanonical.description = _description;
            uncanonical.factoryClassLocation = _factoryClassLocation;
            return (Immutable)IMMUTABLES_COALESCER.coalesce(uncanonical);
        }

        private Immutable() {
        }

        public String getDriverClass() {
            return super.getDriverClass();
        }

        public String getJdbcUrl() {
            return super.getJdbcUrl();
        }

        public Properties getProperties() {
            return super.getProperties();
        }

        public String getDescription() {
            return super.getDescription();
        }

        public String getUser() {
            return super.getUser();
        }

        public String getPassword() {
            return super.getPassword();
        }

        public String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public Immutable asImmutable() {
            return this;
        }

        public boolean equals(Object o) {
            if (o instanceof Immutable) {
                Immutable other = (Immutable)o;
                return ObjectUtils.eqOrBothNull(this.driverClass, other.driverClass) && ObjectUtils.eqOrBothNull(this.jdbcUrl, other.jdbcUrl) && ObjectUtils.eqOrBothNull(this.properties, other.properties) && ObjectUtils.eqOrBothNull(this.description, other.description) && ObjectUtils.eqOrBothNull(this.factoryClassLocation, other.factoryClassLocation);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtils.hashOrZero(this.driverClass) ^ ObjectUtils.hashOrZero(this.jdbcUrl) ^ ObjectUtils.hashOrZero(this.properties) ^ ObjectUtils.hashOrZero(this.description) ^ ObjectUtils.hashOrZero(this.factoryClassLocation);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeShort(1);
            out.writeObject(this.driverClass);
            out.writeObject(this.jdbcUrl);
            out.writeObject(this.properties);
            out.writeObject(this.description);
            out.writeObject(this.factoryClassLocation);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            short version = in.readShort();
            switch (version) {
                case 1: {
                    this.driverClass = (String)in.readObject();
                    this._realizeDriverClass();
                    this.jdbcUrl = (String)in.readObject();
                    this.properties = (Properties)in.readObject();
                    this.description = (String)in.readObject();
                    this.factoryClassLocation = (String)in.readObject();
                    break;
                }
                default: {
                    throw new UnsupportedVersionException(this, version);
                }
            }
        }
    }

    public static class ObjectFactory
    implements javax.naming.spi.ObjectFactory {
        static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable;

        public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
            Reference ref;
            String className = (class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable = ObjectFactory.class$("com.mchange.v2.c3p0.impl.DriverManagerDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable).getName();
            if (refObj instanceof Reference && (ref = (Reference)refObj).getClassName().equals(className)) {
                int version = Integer.parseInt((String)ref.get(DriverManagerDataSource.REFADDR_VERSION).getContent());
                if (version == 1) {
                    String nascentDriverClass = (String)ref.get(DriverManagerDataSource.REFADDR_driverClass).getContent();
                    String nascentJdbcUrl = (String)ref.get(DriverManagerDataSource.REFADDR_jdbcUrl).getContent();
                    Properties nascentProperties = (Properties)SerializableUtils.fromByteArray((byte[])ref.get(DriverManagerDataSource.REFADDR_properties).getContent());
                    String nascentDescription = (String)ref.get(DriverManagerDataSource.REFADDR_description).getContent();
                    return Immutable.find(nascentDriverClass, nascentJdbcUrl, nascentProperties, nascentDescription, ref.getFactoryClassLocation());
                }
                throw new NamingException("Cannot resolve reference (version " + version + " unknown.");
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

