/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.test;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.DataSources;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import javax.sql.DataSource;

public final class LoadPoolBackedDataSource {
    static final int NUM_THREADS = 50;
    static final int ITERATIONS_PER_THREAD = 1000;
    static Random random = new Random();
    static DataSource ds;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$test$LoadPoolBackedDataSource;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] argv) {
        String jdbc_url = null;
        String username = null;
        String password = null;
        if (argv.length == 3) {
            jdbc_url = argv[0];
            username = argv[1];
            password = argv[2];
        } else if (argv.length == 1) {
            jdbc_url = argv[0];
            username = null;
            password = null;
        } else {
            LoadPoolBackedDataSource.usage();
        }
        if (!jdbc_url.startsWith("jdbc:")) {
            LoadPoolBackedDataSource.usage();
        }
        try {
            try {
                int i2;
                block27: {
                    DataSource ds_unpooled = DataSources.unpooledDataSource(jdbc_url, username, password);
                    ds = DataSources.pooledDataSource(ds_unpooled);
                    Connection con = null;
                    Statement stmt = null;
                    try {
                        Object var9_8;
                        try {
                            con = ds.getConnection();
                            stmt = con.createStatement();
                            stmt.executeUpdate("CREATE TABLE testpbds ( a varchar(16), b varchar(16) )");
                            System.err.println("LoadPoolBackedDataSource -- TEST SCHEMA CREATED");
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            System.err.println("relation testpbds already exists, or something bad happened.");
                            var9_8 = null;
                            StatementUtils.attemptClose(stmt);
                            ConnectionUtils.attemptClose(con);
                            break block27;
                        }
                        var9_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        StatementUtils.attemptClose(stmt);
                        ConnectionUtils.attemptClose(con);
                        throw throwable;
                    }
                    StatementUtils.attemptClose(stmt);
                    ConnectionUtils.attemptClose(con);
                }
                Thread[] threads = new Thread[50];
                int i = 0;
                while (true) {
                    if (i >= 50) {
                        i2 = 0;
                        break;
                    }
                    ChurnThread t = new ChurnThread();
                    threads[i] = t;
                    t.start();
                    System.out.println("THREAD MADE [" + i + "]");
                    Thread.sleep(1000L);
                    ++i;
                }
                while (i2 < 50) {
                    threads[i2].join();
                    ++i2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var11_16 = null;
                Connection con = null;
                Statement stmt = null;
                try {}
                catch (Throwable throwable) {
                    Object var16_29 = null;
                    StatementUtils.attemptClose(stmt);
                    ConnectionUtils.attemptClose(con);
                    throw throwable;
                }
                try {}
                catch (SQLException e2) {
                    e2.printStackTrace();
                    Object var16_28 = null;
                    StatementUtils.attemptClose(stmt);
                    ConnectionUtils.attemptClose(con);
                    return;
                }
                con = ds.getConnection();
                stmt = con.createStatement();
                stmt.executeUpdate("DROP TABLE testpbds");
                System.err.println("LoadPoolBackedDataSource -- TEST SCHEMA DROPPED");
                Object var16_27 = null;
                StatementUtils.attemptClose(stmt);
                ConnectionUtils.attemptClose(con);
                return;
            }
            Object var11_15 = null;
            Connection con = null;
            Statement stmt = null;
            try {
                try {
                    con = ds.getConnection();
                    stmt = con.createStatement();
                    stmt.executeUpdate("DROP TABLE testpbds");
                    System.err.println("LoadPoolBackedDataSource -- TEST SCHEMA DROPPED");
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                    Object var16_25 = null;
                    StatementUtils.attemptClose(stmt);
                    ConnectionUtils.attemptClose(con);
                    return;
                }
                Object var16_24 = null;
            }
            catch (Throwable throwable) {
                Object var16_26 = null;
                StatementUtils.attemptClose(stmt);
                ConnectionUtils.attemptClose(con);
                throw throwable;
            }
            StatementUtils.attemptClose(stmt);
            ConnectionUtils.attemptClose(con);
            return;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            Connection con = null;
            Statement stmt = null;
            try {}
            catch (Throwable throwable2) {
                Object var16_32 = null;
                StatementUtils.attemptClose(stmt);
                ConnectionUtils.attemptClose(con);
                throw throwable2;
            }
            try {}
            catch (SQLException e2) {
                e2.printStackTrace();
                Object var16_31 = null;
                StatementUtils.attemptClose(stmt);
                ConnectionUtils.attemptClose(con);
                throw throwable;
            }
            con = ds.getConnection();
            stmt = con.createStatement();
            stmt.executeUpdate("DROP TABLE testpbds");
            System.err.println("LoadPoolBackedDataSource -- TEST SCHEMA DROPPED");
            Object var16_30 = null;
            StatementUtils.attemptClose(stmt);
            ConnectionUtils.attemptClose(con);
            throw throwable;
        }
    }

    static void executeInsert(Connection con) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.executeUpdate("INSERT INTO testpbds VALUES ('" + random.nextInt() + "', '" + random.nextInt() + "')");
            System.out.println("INSERTION");
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            StatementUtils.attemptClose(stmt);
            throw throwable;
        }
        StatementUtils.attemptClose(stmt);
    }

    static void executeSelect(Connection con) throws SQLException {
        long l = System.currentTimeMillis();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT count(*) FROM testpbds");
            rs.next();
            System.out.println("SELECT [count=" + rs.getInt(1) + ", time=" + (System.currentTimeMillis() - l) + " msecs]");
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ResultSetUtils.attemptClose(rs);
            StatementUtils.attemptClose(stmt);
            throw throwable;
        }
        ResultSetUtils.attemptClose(rs);
        StatementUtils.attemptClose(stmt);
    }

    private static void usage() {
        System.err.println("java -Djdbc.drivers=<comma_sep_list_of_drivers> " + (class$com$mchange$v2$c3p0$test$LoadPoolBackedDataSource == null ? (class$com$mchange$v2$c3p0$test$LoadPoolBackedDataSource = LoadPoolBackedDataSource.class$("com.mchange.v2.c3p0.test.LoadPoolBackedDataSource")) : class$com$mchange$v2$c3p0$test$LoadPoolBackedDataSource).getName() + " <jdbc_url> [<username> <password>]");
        System.exit(-1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ChurnThread
    extends Thread {
        ChurnThread() {
        }

        public void run() {
            try {
                int i = 0;
                while (i < 1000) {
                    Object var5_5;
                    Connection con = null;
                    try {
                        con = ds.getConnection();
                        boolean select = random.nextBoolean();
                        if (select) {
                            LoadPoolBackedDataSource.executeSelect(con);
                        } else {
                            LoadPoolBackedDataSource.executeInsert(con);
                        }
                        var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        var5_5 = null;
                        ConnectionUtils.attemptClose(con);
                        throw throwable;
                    }
                    ConnectionUtils.attemptClose(con);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

