/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.naming;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public final class ReferenceableUtils {
    static final String REFADDR_VERSION = "version";
    static final String REFADDR_CLASSNAME = "classname";
    static final String REFADDR_FACTORY = "factory";
    static final String REFADDR_FACTORY_CLASS_LOCATION = "factoryClassLocation";
    static final String REFADDR_SIZE = "size";
    static final int CURRENT_REF_VERSION = 1;

    public static String literalNullToNull(String s) {
        if (s == null || "null".equals(s)) {
            return null;
        }
        return s;
    }

    public static Object referenceToObject(Reference ref, Name name, Context nameCtx, Hashtable env) throws NamingException {
        try {
            ClassLoader cl;
            String fClassName = ref.getFactoryClassName();
            String fClassLocation = ref.getFactoryClassLocation();
            if (fClassLocation == null) {
                cl = ClassLoader.getSystemClassLoader();
            } else {
                URL u = new URL(fClassLocation);
                cl = new URLClassLoader(new URL[]{u}, ClassLoader.getSystemClassLoader());
            }
            Class<?> fClass = Class.forName(fClassName, true, cl);
            ObjectFactory of = (ObjectFactory)fClass.newInstance();
            return of.getObjectInstance(ref, name, nameCtx, env);
        }
        catch (Exception e) {
            e.printStackTrace();
            NamingException ne = new NamingException("Could not resolve Reference to Object!");
            ne.setRootCause(e);
            throw ne;
        }
    }

    public static void appendToReference(Reference appendTo, Reference orig) throws NamingException {
        int len = orig.size();
        appendTo.add(new StringRefAddr(REFADDR_VERSION, String.valueOf(1)));
        appendTo.add(new StringRefAddr(REFADDR_CLASSNAME, orig.getClassName()));
        appendTo.add(new StringRefAddr(REFADDR_FACTORY, orig.getFactoryClassName()));
        appendTo.add(new StringRefAddr(REFADDR_FACTORY_CLASS_LOCATION, orig.getFactoryClassLocation()));
        appendTo.add(new StringRefAddr(REFADDR_SIZE, String.valueOf(len)));
        int i = 0;
        while (i < len) {
            appendTo.add(orig.get(i));
            ++i;
        }
    }

    public static ExtractRec extractNestedReference(Reference extractFrom, int index) throws NamingException {
        try {
            int version = Integer.parseInt((String)extractFrom.get(index++).getContent());
            if (version == 1) {
                String className = (String)extractFrom.get(index++).getContent();
                String factoryClassName = (String)extractFrom.get(index++).getContent();
                String factoryClassLocation = (String)extractFrom.get(index++).getContent();
                Reference outRef = new Reference(className, factoryClassName, factoryClassLocation);
                int size = Integer.parseInt((String)extractFrom.get(index++).getContent());
                int i = 0;
                while (i < size) {
                    outRef.add(extractFrom.get(index++));
                    ++i;
                }
                return new ExtractRec(outRef, index);
            }
            throw new NamingException("Bad version of nested reference!!!");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new NamingException("Version or size nested reference was not a number!!!");
        }
    }

    private ReferenceableUtils() {
    }

    public static class ExtractRec {
        public Reference ref;
        public int index;

        private ExtractRec(Reference ref, int index) {
            this.ref = ref;
            this.index = index;
        }
    }
}

