/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.ddl2hbm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Beans;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.hibernate.tool.ddl2hbm.JDBCUtil;
import net.sf.hibernate.tool.ddl2hbm.MapGenerator;
import net.sf.hibernate.tool.ddl2hbm.ParamsPanel;

public class Gui
extends JApplet {
    static final Object[] javaKeyTypes = new String[]{"java.util.Date", "java.lang.Long", "java.lang.String", "java.sql.Timestamp"};
    static final Object[] hibernateKeyTypes = new String[]{"date", "long", "string", "timestamp"};
    static final int DATE_TYPE = 0;
    static final int LONG_TYPE = 1;
    static final int STRING_TYPE = 2;
    static final int TIMESTAMP_TYPE = 3;
    DefaultComboBoxModel javaTypesModel = new DefaultComboBoxModel<Object>(javaKeyTypes);
    DefaultComboBoxModel hibernateTypesModel = new DefaultComboBoxModel<Object>(hibernateKeyTypes);
    String[] generationParameters;
    Map schemas;
    private JRadioButton optionSingleMap;
    private JComboBox generatorName;
    private JTextField tableName;
    private JTextField packageName;
    private JTextField outputDirectory;
    private JPanel cmdPanel;
    private JTextField mappingFile;
    private JTextField dbUser;
    private ButtonGroup buttonGroup1;
    private JList selectedTables;
    private JButton cmdParams;
    private JPanel tableListHolder;
    private JPanel mappingPanel;
    private JButton cmdGenerate;
    private JLabel jLabel9;
    private JLabel jLabel8;
    private JLabel jLabel7;
    private JLabel jLabel14;
    private JLabel jLabel13;
    private JComboBox schemaName;
    private JLabel jLabel6;
    private JLabel jLabel5;
    private JLabel jLabel12;
    private ButtonGroup keyFieldTypeGroup;
    private JLabel jLabel11;
    private JTextField idFieldName;
    private JLabel jLabel4;
    private JPanel databasePanel;
    private JLabel jLabel3;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JPanel connectionPanel;
    private JComboBox catalogName;
    private JRadioButton optionTableMap;
    private JButton cmdGetTables;
    private JScrollPane tablesScroller;
    private JPanel mappingTypePanel;
    private JPanel jPanel5;
    private JPasswordField dbPassword;
    private ButtonGroup mappingTypeGroup;
    private JPanel jPanel1;
    private JComboBox keyFieldType;
    private JLabel Generator;
    private JTextField connectionUrl;
    private JTextField driverClass;
    private JTextField baseClass;
    private JPanel tablesPanel;
    private JRadioButton optionHibernateTypes;
    private JTabbedPane tabbedPanel;
    private JPanel codePanel;
    private JPanel genPanel;
    private JButton cmdPickDir;
    private JPanel outputPanel;
    private JRadioButton optionJavaTypes;
    static /* synthetic */ Class class$net$sf$hibernate$tool$ddl2hbm$Gui;

    public Gui() {
        this.initComponents();
        this.keyFieldType.setModel(this.hibernateTypesModel);
        this.generatorNameItemStateChanged(null);
        this.readState();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Gui.this.saveState();
            }
        });
    }

    private void initComponents() {
        this.mappingTypeGroup = new ButtonGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.databasePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.catalogName = new JComboBox();
        this.jLabel2 = new JLabel();
        this.schemaName = new JComboBox();
        this.jLabel3 = new JLabel();
        this.tableName = new JTextField();
        this.keyFieldTypeGroup = new ButtonGroup();
        this.tabbedPanel = new JTabbedPane();
        this.connectionPanel = new JPanel();
        this.jLabel6 = new JLabel();
        this.driverClass = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.connectionUrl = new JTextField();
        this.dbUser = new JTextField();
        this.dbPassword = new JPasswordField();
        this.jPanel5 = new JPanel();
        this.tablesPanel = new JPanel();
        this.tableListHolder = new JPanel();
        this.cmdGetTables = new JButton();
        this.tablesScroller = new JScrollPane();
        this.selectedTables = new JList();
        this.mappingPanel = new JPanel();
        this.jLabel11 = new JLabel();
        this.mappingTypePanel = new JPanel();
        this.optionSingleMap = new JRadioButton();
        this.optionTableMap = new JRadioButton();
        this.mappingFile = new JTextField();
        this.jLabel10 = new JLabel();
        this.idFieldName = new JTextField();
        this.Generator = new JLabel();
        this.genPanel = new JPanel();
        this.generatorName = new JComboBox();
        this.cmdParams = new JButton();
        this.jLabel12 = new JLabel();
        this.jPanel1 = new JPanel();
        this.optionHibernateTypes = new JRadioButton();
        this.optionJavaTypes = new JRadioButton();
        this.keyFieldType = new JComboBox();
        this.jLabel14 = new JLabel();
        this.codePanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.packageName = new JTextField();
        this.jLabel13 = new JLabel();
        this.baseClass = new JTextField();
        this.outputPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.outputDirectory = new JTextField();
        this.cmdPickDir = new JButton();
        this.cmdPanel = new JPanel();
        this.cmdGenerate = new JButton();
        this.databasePanel.setLayout(new GridBagLayout());
        this.databasePanel.setMinimumSize(new Dimension(250, 70));
        this.databasePanel.setPreferredSize(new Dimension(250, 75));
        this.jLabel1.setText("Catalog");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.databasePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.catalogName.setMinimumSize(new Dimension(31, 20));
        this.catalogName.setNextFocusableComponent(this.schemaName);
        this.catalogName.setPreferredSize(new Dimension(31, 20));
        this.catalogName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Gui.this.catalogNameItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.databasePanel.add((Component)this.catalogName, gridBagConstraints);
        this.jLabel2.setText("Schema");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.databasePanel.add((Component)this.jLabel2, gridBagConstraints);
        this.schemaName.setMinimumSize(new Dimension(31, 20));
        this.schemaName.setNextFocusableComponent(this.tableName);
        this.schemaName.setPreferredSize(new Dimension(31, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.databasePanel.add((Component)this.schemaName, gridBagConstraints);
        this.jLabel3.setText("Table Filter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.databasePanel.add((Component)this.jLabel3, gridBagConstraints);
        this.tableName.setText("%");
        this.tableName.setNextFocusableComponent(this.catalogName);
        this.tableName.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.databasePanel.add((Component)this.tableName, gridBagConstraints);
        this.tabbedPanel.setFont(new Font("Dialog", 1, 11));
        this.tabbedPanel.setPreferredSize(new Dimension(430, 240));
        this.connectionPanel.setLayout(new GridBagLayout());
        this.jLabel6.setText("Driver Class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.connectionPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.driverClass.setText("oracle.jdbc.OracleDriver");
        this.driverClass.setNextFocusableComponent(this.connectionUrl);
        this.driverClass.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.connectionPanel.add((Component)this.driverClass, gridBagConstraints);
        this.jLabel7.setText("Connection URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.connectionPanel.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText("Username");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.connectionPanel.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setText("Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.connectionPanel.add((Component)this.jLabel9, gridBagConstraints);
        this.connectionUrl.setText("jdbc:oracle:thin:@host:port:dbi");
        this.connectionUrl.setNextFocusableComponent(this.dbUser);
        this.connectionUrl.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.connectionPanel.add((Component)this.connectionUrl, gridBagConstraints);
        this.dbUser.setNextFocusableComponent(this.dbPassword);
        this.dbUser.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.connectionPanel.add((Component)this.dbUser, gridBagConstraints);
        this.dbPassword.setNextFocusableComponent(this.driverClass);
        this.dbPassword.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.connectionPanel.add((Component)this.dbPassword, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.connectionPanel.add((Component)this.jPanel5, gridBagConstraints);
        this.tabbedPanel.addTab("Connection", this.connectionPanel);
        this.tablesPanel.setLayout(new BorderLayout());
        this.tableListHolder.setLayout(new GridBagLayout());
        this.cmdGetTables.setFont(new Font("Dialog", 0, 12));
        this.cmdGetTables.setText("tables...");
        this.cmdGetTables.setFocusPainted(false);
        this.cmdGetTables.setMaximumSize(new Dimension(150, 26));
        this.cmdGetTables.setMinimumSize(new Dimension(80, 20));
        this.cmdGetTables.setPreferredSize(new Dimension(85, 20));
        this.cmdGetTables.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Gui.this.cmdGetTablesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.tableListHolder.add((Component)this.cmdGetTables, gridBagConstraints);
        this.selectedTables.setFont(new Font("Dialog", 0, 12));
        this.selectedTables.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                Gui.this.selectedTablesValueChanged(evt);
            }
        });
        this.tablesScroller.setViewportView(this.selectedTables);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.tableListHolder.add((Component)this.tablesScroller, gridBagConstraints);
        this.tablesPanel.add((Component)this.tableListHolder, "Center");
        this.tabbedPanel.addTab("Tables", this.tablesPanel);
        this.mappingPanel.setLayout(new GridBagLayout());
        this.jLabel11.setText("Mapping File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        this.mappingPanel.add((Component)this.jLabel11, gridBagConstraints);
        this.mappingTypePanel.setLayout(new GridBagLayout());
        this.mappingTypePanel.setBorder(new EtchedBorder());
        this.mappingTypePanel.setMinimumSize(new Dimension(184, 55));
        this.optionSingleMap.setFont(new Font("Dialog", 0, 12));
        this.optionSingleMap.setText("single map");
        this.mappingTypeGroup.add(this.optionSingleMap);
        this.optionSingleMap.setMinimumSize(new Dimension(87, 20));
        this.optionSingleMap.setNextFocusableComponent(this.idFieldName);
        this.optionSingleMap.setPreferredSize(new Dimension(87, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 2, 0);
        this.mappingTypePanel.add((Component)this.optionSingleMap, gridBagConstraints);
        this.optionTableMap.setFont(new Font("Dialog", 0, 12));
        this.optionTableMap.setSelected(true);
        this.optionTableMap.setText("one map per database table");
        this.mappingTypeGroup.add(this.optionTableMap);
        this.optionTableMap.setNextFocusableComponent(this.optionSingleMap);
        this.optionTableMap.setPreferredSize(new Dimension(183, 20));
        this.optionTableMap.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Gui.this.optionTableMapItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.mappingTypePanel.add((Component)this.optionTableMap, gridBagConstraints);
        this.mappingFile.setText("mapping.hbm.xml");
        this.mappingFile.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.mappingTypePanel.add((Component)this.mappingFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.mappingPanel.add((Component)this.mappingTypePanel, gridBagConstraints);
        this.jLabel10.setText("Key Field Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.mappingPanel.add((Component)this.jLabel10, gridBagConstraints);
        this.idFieldName.setText("id");
        this.idFieldName.setMinimumSize(new Dimension(220, 20));
        this.idFieldName.setNextFocusableComponent(this.generatorName);
        this.idFieldName.setPreferredSize(new Dimension(220, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.mappingPanel.add((Component)this.idFieldName, gridBagConstraints);
        this.Generator.setText("SchemaExport");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.mappingPanel.add((Component)this.Generator, gridBagConstraints);
        this.genPanel.setLayout(new GridBagLayout());
        this.genPanel.setPreferredSize(new Dimension(250, 20));
        this.generatorName.setEditable(true);
        this.generatorName.setFont(new Font("Dialog", 0, 12));
        this.generatorName.setModel(new DefaultComboBoxModel<String>(new String[]{"uuid.hex", "uuid.string", "vm.long", "vm.hex", "assigned", "native", "sequence", "hilo.long", "hilo.hex", "seqhilo.long"}));
        this.generatorName.setSelectedIndex(6);
        this.generatorName.setNextFocusableComponent(this.cmdParams);
        this.generatorName.setPreferredSize(new Dimension(140, 20));
        this.generatorName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Gui.this.generatorNameItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.genPanel.add((Component)this.generatorName, gridBagConstraints);
        this.cmdParams.setFont(new Font("Dialog", 0, 12));
        this.cmdParams.setText("params...");
        this.cmdParams.setNextFocusableComponent(this.keyFieldType);
        this.cmdParams.setPreferredSize(new Dimension(88, 20));
        this.cmdParams.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Gui.this.cmdParamsActionPerformed(evt);
            }
        });
        this.genPanel.add((Component)this.cmdParams, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.mappingPanel.add((Component)this.genPanel, gridBagConstraints);
        this.jLabel12.setText("Key Field Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.mappingPanel.add((Component)this.jLabel12, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new EtchedBorder());
        this.optionHibernateTypes.setFont(new Font("Dialog", 0, 12));
        this.optionHibernateTypes.setSelected(true);
        this.optionHibernateTypes.setText("use Hibernate types");
        this.keyFieldTypeGroup.add(this.optionHibernateTypes);
        this.optionHibernateTypes.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Gui.this.optionHibernateTypesItemStateChanged(evt);
            }
        });
        this.jPanel1.add((Component)this.optionHibernateTypes, new GridBagConstraints());
        this.optionJavaTypes.setFont(new Font("Dialog", 0, 12));
        this.optionJavaTypes.setText("use Java types");
        this.keyFieldTypeGroup.add(this.optionJavaTypes);
        this.jPanel1.add((Component)this.optionJavaTypes, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.mappingPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.keyFieldType.setFont(new Font("Dialog", 0, 12));
        this.keyFieldType.setModel(new DefaultComboBoxModel<String>(new String[]{"date", "integer", "long", "string", "timestamp"}));
        this.keyFieldType.setSelectedIndex(2);
        this.keyFieldType.setNextFocusableComponent(this.optionTableMap);
        this.keyFieldType.setPreferredSize(new Dimension(31, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.mappingPanel.add((Component)this.keyFieldType, gridBagConstraints);
        this.jLabel14.setText("Key Field Class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.mappingPanel.add((Component)this.jLabel14, gridBagConstraints);
        this.tabbedPanel.addTab("Mapping", this.mappingPanel);
        this.codePanel.setLayout(new GridBagLayout());
        this.codePanel.setMinimumSize(new Dimension(350, 112));
        this.codePanel.setPreferredSize(new Dimension(350, 150));
        this.jLabel4.setText("Package Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.codePanel.add((Component)this.jLabel4, gridBagConstraints);
        this.packageName.setNextFocusableComponent(this.baseClass);
        this.packageName.setPreferredSize(new Dimension(220, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.codePanel.add((Component)this.packageName, gridBagConstraints);
        this.jLabel13.setText("Base Class Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.codePanel.add((Component)this.jLabel13, gridBagConstraints);
        this.baseClass.setNextFocusableComponent(this.packageName);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.codePanel.add((Component)this.baseClass, gridBagConstraints);
        this.tabbedPanel.addTab("Code", this.codePanel);
        this.outputPanel.setLayout(new GridBagLayout());
        this.jLabel5.setText("Output Directory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.outputPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.outputDirectory.setEditable(false);
        this.outputDirectory.setText("c:\\temp");
        this.outputDirectory.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.outputPanel.add((Component)this.outputDirectory, gridBagConstraints);
        this.cmdPickDir.setFont(new Font("Dialog", 0, 12));
        this.cmdPickDir.setText("pick...");
        this.cmdPickDir.setPreferredSize(new Dimension(80, 20));
        this.cmdPickDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Gui.this.cmdPickDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.outputPanel.add((Component)this.cmdPickDir, gridBagConstraints);
        this.tabbedPanel.addTab("Output", this.outputPanel);
        this.getContentPane().add((Component)this.tabbedPanel, "Center");
        this.cmdGenerate.setText("Generate");
        this.cmdGenerate.setEnabled(false);
        this.cmdGenerate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Gui.this.cmdGenerateActionPerformed(evt);
            }
        });
        this.cmdPanel.add(this.cmdGenerate);
        this.getContentPane().add((Component)this.cmdPanel, "South");
    }

    private void optionHibernateTypesItemStateChanged(ItemEvent evt) {
        int selectedIndex = this.keyFieldType.getSelectedIndex();
        if (this.optionHibernateTypes.isSelected()) {
            this.keyFieldType.setModel(this.hibernateTypesModel);
        } else {
            this.keyFieldType.setModel(this.javaTypesModel);
        }
        this.keyFieldType.setSelectedIndex(selectedIndex);
    }

    private void catalogNameItemStateChanged(ItemEvent evt) {
        List tmp = (List)this.schemas.get(this.catalogName.getSelectedItem());
        Object[] schemaArr = tmp != null ? tmp.toArray() : new Object[]{};
        DefaultComboBoxModel<Object> dcbm = new DefaultComboBoxModel<Object>(schemaArr);
        this.schemaName.setModel(dcbm);
        this.schemaName.setSelectedItem(this.dbUser.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmdGetTablesActionPerformed(ActionEvent evt) {
        try {
            Connection c = null;
            try {
                c = this.getConnection();
                DefaultComboBoxModel<Object> dcbm = new DefaultComboBoxModel<Object>(JDBCUtil.getCatalogs(c).toArray());
                this.catalogName.setModel(dcbm);
                this.schemas = JDBCUtil.getSchemas(c);
                List tmp = (List)this.schemas.get(this.catalogName.getSelectedItem());
                Object[] schemaArr = tmp != null ? tmp.toArray() : new Object[]{};
                dcbm = new DefaultComboBoxModel<Object>(schemaArr);
                Object prevItem = this.schemaName.getSelectedItem();
                this.schemaName.setModel(dcbm);
                if (prevItem == null) {
                    this.schemaName.setSelectedItem(this.dbUser.getText());
                }
                JOptionPane.showMessageDialog(this, this.databasePanel, "SimpleSelect Table Criteria", 3);
                List tables = JDBCUtil.getTables(c, (String)this.catalogName.getSelectedItem(), (String)this.schemaName.getSelectedItem(), this.tableName.getText());
                dcbm = new DefaultComboBoxModel<Object>(tables.toArray());
                this.selectedTables.setModel(dcbm);
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e);
        }
    }

    private void selectedTablesValueChanged(ListSelectionEvent evt) {
        int[] selected = this.selectedTables.getSelectedIndices();
        this.cmdGenerate.setEnabled(selected != null && selected.length != 0);
    }

    private void optionTableMapItemStateChanged(ItemEvent evt) {
        this.mappingFile.setEnabled(!this.optionTableMap.isSelected());
    }

    private void generatorNameItemStateChanged(ItemEvent evt) {
        if (this.generatorName.getSelectedIndex() != -1) {
            String gName = (String)this.generatorName.getSelectedItem();
            if (gName.equals("vm.long") || gName.equals("native") || gName.equals("sequence") || gName.equals("hilo.long") || gName.equals("seqhilo.long")) {
                this.keyFieldType.setSelectedIndex(1);
            } else if (gName.equals("uuid.hex") || gName.equals("uuid.string") || gName.equals("vm.hex") || gName.equals("hilo.hex")) {
                this.keyFieldType.setSelectedIndex(2);
            }
        }
    }

    private void cmdParamsActionPerformed(ActionEvent evt) {
        int choice;
        ParamsPanel paramsPanel = new ParamsPanel();
        if (this.generationParameters != null) {
            paramsPanel.setParameters(this.generationParameters);
        }
        if ((choice = JOptionPane.showConfirmDialog(this, paramsPanel, "Generation Parameters", 2)) == 0) {
            this.generationParameters = paramsPanel.getParameters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cmdGenerateActionPerformed(ActionEvent evt) {
        String baseClassName;
        String idType;
        String id;
        String dir;
        String pack;
        Object[] otables;
        String schem;
        Connection connection = null;
        MapGenerator mg = new MapGenerator();
        String cat = (String)this.catalogName.getSelectedItem();
        if (cat != null && cat.length() > 0) {
            mg.setCatalog(cat);
        }
        if ((schem = (String)this.schemaName.getSelectedItem()) != null && schem.length() > 0) {
            mg.setSchemaPattern(schem);
        }
        if ((otables = this.selectedTables.getSelectedValues()) != null && otables.length > 0) {
            String[] tables = Arrays.asList(otables).toArray(new String[0]);
            mg.setTableNames(tables);
        }
        if ((pack = this.packageName.getText()) != null && pack.length() > 0) {
            mg.setPackageName(pack);
        }
        if ((dir = this.outputDirectory.getText()) != null && dir.length() > 0) {
            mg.setOutputDirectory(new File(dir));
        }
        if ((id = this.idFieldName.getText()) != null && id.length() > 0) {
            mg.setIdName(id);
        }
        if ((idType = (String)this.keyFieldType.getSelectedItem()) != null && idType.length() > 0) {
            mg.setIdType(idType);
        }
        if ((baseClassName = this.baseClass.getText()) != null && baseClassName.length() > 0) {
            mg.setBaseClass(baseClassName);
        }
        mg.setHibernateTypes(this.optionHibernateTypes.isSelected());
        String generator = (String)this.generatorName.getSelectedItem();
        if (generator != null) {
            mg.setGenerator(generator);
            if (this.generationParameters != null) {
                mg.setGeneratorParameters(this.generationParameters);
            }
        }
        mg.setSingleMapFile(this.optionSingleMap.isSelected());
        if (this.optionSingleMap.isSelected()) {
            mg.setMappingFile(this.mappingFile.getText());
        }
        connection = this.getConnection();
        mg.generate(connection);
        Object var14_14 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e);
                e.printStackTrace();
                Object var14_15 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void cmdPickDirActionPerformed(ActionEvent evt) {
        int returnVal;
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose an output directory");
        jfc.setFileSelectionMode(1);
        String outputDir = this.outputDirectory.getText();
        if (outputDir != null && outputDir.length() > 0) {
            jfc.setCurrentDirectory(new File(outputDir));
        }
        if ((returnVal = jfc.showOpenDialog(this)) == 0) {
            this.outputDirectory.setText(jfc.getSelectedFile().getAbsolutePath());
        }
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("Hibernate Mapping SchemaExport");
        try {
            Gui applet = (Gui)Beans.instantiate((class$net$sf$hibernate$tool$ddl2hbm$Gui == null ? (class$net$sf$hibernate$tool$ddl2hbm$Gui = Gui.class$("net.sf.hibernate.tool.ddl2hbm.Gui")) : class$net$sf$hibernate$tool$ddl2hbm$Gui).getClassLoader(), (class$net$sf$hibernate$tool$ddl2hbm$Gui == null ? (class$net$sf$hibernate$tool$ddl2hbm$Gui = Gui.class$("net.sf.hibernate.tool.ddl2hbm.Gui")) : class$net$sf$hibernate$tool$ddl2hbm$Gui).getName());
            frame.getContentPane().add(applet);
            frame.pack();
            frame.setResizable(true);
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameDim = frame.getSize();
            Point frameCenter = new Point((int)(screenDim.getWidth() - frameDim.getWidth()) / 2, (int)(screenDim.getHeight() - frameDim.getHeight()) / 2);
            frame.setLocation(frameCenter);
            frame.setDefaultCloseOperation(3);
            frame.show();
        }
        catch (Exception e) {
            JOptionPane.showConfirmDialog(frame, e);
        }
    }

    protected Connection getConnection() throws SQLException, ClassNotFoundException {
        Class.forName(this.driverClass.getText());
        return DriverManager.getConnection(this.connectionUrl.getText(), this.dbUser.getText(), new String(this.dbPassword.getPassword()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveState() {
        Properties p = new Properties();
        p.put("driverClass", this.driverClass.getText());
        p.put("connectionUrl", this.connectionUrl.getText());
        p.put("dbUser", this.dbUser.getText());
        p.put("tableName", this.tableName.getText());
        p.put("singleMapType", "" + this.optionSingleMap.isSelected());
        p.put("mapName", this.mappingFile.getText());
        p.put("generatorName", this.generatorName.getSelectedItem());
        if (this.generationParameters != null) {
            String gp = "";
            for (int i = 0; i < this.generationParameters.length; ++i) {
                gp = gp + this.generationParameters[i] + "\t";
            }
            p.put("generatorParameters", gp);
        }
        p.put("keyFieldName", this.idFieldName.getText());
        p.put("keyFieldType", this.keyFieldType.getSelectedItem());
        p.put("useHibernateTypes", "" + this.optionHibernateTypes.isSelected());
        p.put("packageName", this.packageName.getText());
        p.put("baseClass", this.baseClass.getText());
        p.put("outputDirectory", this.outputDirectory.getText());
        File propsFile = new File(System.getProperty("user.home"), "mapgen.properties");
        try {
            FileOutputStream fos = new FileOutputStream(propsFile);
            try {
                p.store(fos, "SchemaExport");
            }
            finally {
                fos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readState() {
        File propsFile = new File(System.getProperty("user.home"), "mapgen.properties");
        Properties p = new Properties();
        try {
            FileInputStream fis = new FileInputStream(propsFile);
            try {
                String gp;
                p.load(fis);
                this.driverClass.setText(p.getProperty("driverClass"));
                this.connectionUrl.setText(p.getProperty("connectionUrl"));
                this.dbUser.setText(p.getProperty("dbUser"));
                this.tableName.setText(p.getProperty("tableName"));
                String mapType = p.getProperty("singleMapType");
                if (p.getProperty("mapName") != null) {
                    this.mappingFile.setText(p.getProperty("mapName"));
                }
                this.optionSingleMap.setSelected(mapType != null && mapType.equals("true"));
                this.generatorName.setSelectedItem(p.getProperty("generatorName"));
                if (p.getProperty("keyFieldName") != null) {
                    this.idFieldName.setText(p.getProperty("keyFieldName"));
                }
                this.keyFieldType.setSelectedItem(p.getProperty("keyFieldType"));
                String useHibernateTypes = p.getProperty("useHibernateTypes");
                this.optionJavaTypes.setSelected(useHibernateTypes != null && useHibernateTypes.equals("false"));
                this.packageName.setText(p.getProperty("packageName"));
                this.baseClass.setText(p.getProperty("baseClass"));
                if (p.getProperty("outputDirectory") != null) {
                    this.outputDirectory.setText(p.getProperty("outputDirectory"));
                }
                if ((gp = p.getProperty("generatorParameters")) != null) {
                    StringTokenizer st = new StringTokenizer(gp, "\t");
                    this.generationParameters = new String[st.countTokens()];
                    for (int i = 0; i < this.generationParameters.length; ++i) {
                        this.generationParameters[i] = st.nextToken();
                    }
                }
            }
            finally {
                fis.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

