/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.tool.hbm2java.ClassMapping;
import net.sf.hibernate.tool.hbm2java.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;

public class Generator {
    private Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$tool$hbm2java$Generator == null ? (class$net$sf$hibernate$tool$hbm2java$Generator = Generator.class$("net.sf.hibernate.tool.hbm2java.Generator")) : class$net$sf$hibernate$tool$hbm2java$Generator));
    private String rendererClass = "net.sf.hibernate.tool.hbm2java.BasicRenderer";
    private String baseDirName = "generated";
    private String packageName = null;
    private String suffix = "";
    private String extension = "java";
    private boolean lowerFirstLetter = false;
    static /* synthetic */ Class class$net$sf$hibernate$tool$hbm2java$Generator;

    public Generator() {
    }

    public Generator(Element generateElement) throws Exception {
        String value = null;
        this.rendererClass = generateElement.getAttributeValue("renderer");
        if (this.rendererClass == null) {
            throw new Exception("attribute renderer is required.");
        }
        value = generateElement.getAttributeValue("dir");
        if (value != null) {
            this.baseDirName = value;
        }
        this.packageName = generateElement.getAttributeValue("package");
        value = generateElement.getAttributeValue("suffix");
        if (value != null) {
            this.suffix = value;
        }
        if ((value = generateElement.getAttributeValue("extension")) != null) {
            this.extension = value;
        }
        value = generateElement.getAttributeValue("lowerFirstLetter");
        this.lowerFirstLetter = Boolean.valueOf(value);
    }

    public void generate(Map classMappingsCol) throws Exception {
        Renderer renderer = (Renderer)Class.forName(this.rendererClass).newInstance();
        Iterator classMappings = classMappingsCol.values().iterator();
        while (classMappings.hasNext()) {
            ClassMapping classMapping = (ClassMapping)classMappings.next();
            this.writeRecur(classMapping, classMappingsCol, renderer);
        }
        Iterator cmpMappings = ClassMapping.getComponents();
        while (cmpMappings.hasNext()) {
            ClassMapping mapping = (ClassMapping)cmpMappings.next();
            this.write(mapping, classMappingsCol, renderer);
        }
    }

    private void writeRecur(ClassMapping classMapping, Map class2classmap, Renderer renderer) throws Exception {
        this.write(classMapping, class2classmap, renderer);
        if (!classMapping.getSubclasses().isEmpty()) {
            Iterator it = classMapping.getSubclasses().iterator();
            while (it.hasNext()) {
                this.writeRecur((ClassMapping)it.next(), class2classmap, renderer);
            }
        }
    }

    private void write(ClassMapping classMapping, Map class2classmap, Renderer renderer) throws Exception {
        File dir = this.getDir(classMapping.getGeneratedPackageName());
        File file = new File(dir, this.getFileName(classMapping.getGeneratedName()));
        this.log.debug((Object)("Writing " + file));
        PrintWriter writer = new PrintWriter(new FileOutputStream(file));
        renderer.render(this.packageName, this.getName(classMapping.getGeneratedName()), classMapping, class2classmap, writer);
        writer.close();
    }

    private String getFileName(String className) {
        return this.getName(className) + "." + this.extension;
    }

    private String getName(String className) {
        String name = null;
        name = this.lowerFirstLetter ? className.substring(0, 1).toLowerCase() + className.substring(1, className.length()) : className;
        return name + this.suffix;
    }

    private File getDir(String packageName) throws Exception {
        File baseDir = new File(this.baseDirName);
        File dir = null;
        dir = this.packageName == null ? new File(baseDir, packageName == null ? "" : packageName.replace('.', File.separatorChar)) : new File(baseDir, this.packageName.replace('.', File.separatorChar));
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new Exception("The path: " + dir.getCanonicalPath() + " exists, but is not a directory");
            }
        } else if (!dir.mkdirs()) {
            throw new Exception("unable to create directory: " + dir.getCanonicalPath());
        }
        return dir;
    }

    public String getBaseDirName() {
        return this.baseDirName;
    }

    public void setBaseDirName(String baseDirName) {
        if (baseDirName != null) {
            this.baseDirName = baseDirName;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

