/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jisp;

import com.coyotegulch.jisp.BTreeIndex;
import com.coyotegulch.jisp.IndexedObjectDatabase;
import com.coyotegulch.jisp.KeyObject;
import com.coyotegulch.jisp.ObjectIndex;
import java.io.File;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.jcs.auxiliary.disk.jisp.JISPCacheAttributes;
import org.apache.jcs.auxiliary.disk.jisp.JISPKey;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;

public class JISPCache
extends AbstractDiskCache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$jisp$JISPCache == null ? (class$org$apache$jcs$auxiliary$disk$jisp$JISPCache = JISPCache.class$("org.apache.jcs.auxiliary.disk.jisp.JISPCache")) : class$org$apache$jcs$auxiliary$disk$jisp$JISPCache));
    private int numInstances = 0;
    public boolean isAlive = false;
    JISPCacheAttributes cattr;
    IndexedObjectDatabase database;
    BTreeIndex index1;
    private static int s_order = 101;
    String jispDataFileName = "default_this_is_BAD";
    String jispIndexFileName = "default_this_is_BAD";
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$jisp$JISPCache;

    public JISPCache(JISPCacheAttributes cattr) {
        super(cattr.getCacheName());
        ++this.numInstances;
        String rafroot = cattr.getDiskPath();
        if (rafroot == null) {
            log.warn((Object)"The JISP directory was not defined in the cache.ccf ");
            rafroot = "";
        }
        this.jispDataFileName = rafroot + this.cacheName + "DATA.jisp";
        this.jispIndexFileName = rafroot + this.cacheName + "INDEX.jisp";
        log.debug((Object)("jispDataFileName = " + this.jispDataFileName));
        try {
            File finddb = new File(this.jispDataFileName);
            if (!finddb.exists() || cattr.getClearOnStart()) {
                this.setupTABLE();
            }
            try {
                this.createDB(cattr.getClearOnStart());
            }
            catch (Exception e) {
                log.error((Object)e);
                this.reset();
            }
            this.isAlive = true;
        }
        catch (Exception e) {
            log.error((Object)"QueryTool.init", (Throwable)e);
            this.reset();
        }
    }

    void setupTABLE() {
        try {
            File killit = new File(this.jispDataFileName);
            if (killit.exists()) {
                killit.delete();
            }
            if ((killit = new File(this.jispIndexFileName)).exists()) {
                killit.delete();
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
            log.error((Object)e);
        }
    }

    public void createDB(boolean clear) throws Exception {
        try {
            this.database = new IndexedObjectDatabase(this.jispDataFileName, clear);
            this.index1 = new BTreeIndex(this.jispIndexFileName, s_order, (KeyObject)new JISPKey(), false);
            this.database.attachIndex((ObjectIndex)this.index1);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
            log.error((Object)e);
            throw e;
        }
    }

    protected void doUpdate(ICacheElement ce) {
        if (!this.isAlive) {
            log.warn((Object)"not alive");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Putting " + ce.getKey() + " on disk"));
        }
        try {
            KeyObject[] keyArray = new JISPKey[]{new JISPKey(ce.getKey())};
            this.database.write(keyArray, (Serializable)ce);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    protected ICacheElement doGet(Serializable key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting " + key + " from disk"));
        }
        if (!this.isAlive) {
            return null;
        }
        CacheElement element = null;
        try {
            element = (CacheElement)this.database.read((KeyObject)new JISPKey(key), (ObjectIndex)this.index1);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        if (element == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" " + key + ", val = " + element.getVal()));
        }
        return element;
    }

    public Set getGroupKeys(String groupName) {
        throw new UnsupportedOperationException("Groups not implemented.");
    }

    protected boolean doRemove(Serializable key) {
        KeyObject[] keyArray = new JISPKey[]{new JISPKey(key)};
        try {
            this.database.remove(keyArray);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.reset();
        }
        return false;
    }

    protected void doRemoveAll() {
        try {
            this.reset();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void reset() {
        try {
            this.setupTABLE();
            this.createDB(true);
        }
        catch (Exception e) {
            log.warn((Object)"Trying to create error files, two programs must be using the same JISP directory");
            try {
                this.jispDataFileName = this.jispDataFileName + ".error";
                this.jispIndexFileName = this.jispIndexFileName + ".error";
                this.setupTABLE();
                this.createDB(true);
            }
            catch (Exception e2) {
                log.error((Object)"Could not create error files!", (Throwable)e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDispose() {
        if (!this.isAlive) {
            log.error((Object)("is not alive and close() was called -- " + this.jispDataFileName));
            return;
        }
        try {
            try {
                this.database.close();
            }
            catch (Exception e) {
                log.error((Object)e);
                Object var3_2 = null;
                this.isAlive = false;
            }
            Object var3_1 = null;
            this.isAlive = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.isAlive = false;
            throw throwable;
        }
    }

    public int getSize() {
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

