/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.RemoteCacheInfo;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;

public class RemoteCacheListener
implements IRemoteCacheListener,
IRemoteCacheConstants,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteCacheListener == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCacheListener = RemoteCacheListener.class$("org.apache.jcs.auxiliary.remote.RemoteCacheListener")) : class$org$apache$jcs$auxiliary$remote$RemoteCacheListener));
    protected static transient CompositeCacheManager cacheMgr;
    protected static IRemoteCacheListener instance;
    protected IRemoteCacheAttributes irca;
    protected int puts = 0;
    protected int removes = 0;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteCacheListener;

    protected RemoteCacheListener(IRemoteCacheAttributes irca) {
        this.irca = irca;
        try {
            if (irca.getLocalPort() != 0) {
                UnicastRemoteObject.exportObject((Remote)this, irca.getLocalPort());
            } else {
                UnicastRemoteObject.exportObject(this);
            }
        }
        catch (RemoteException ex) {
            log.error((Object)ex);
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public void setListenerId(byte id) throws IOException {
        RemoteCacheInfo.listenerId = id;
        if (log.isDebugEnabled()) {
            log.debug((Object)("set listenerId = " + id));
        }
    }

    public byte getListenerId() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("get listenerId = " + RemoteCacheInfo.listenerId));
        }
        return RemoteCacheInfo.listenerId;
    }

    public int getRemoteType() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getRemoteType = " + this.irca.getRemoteType()));
        }
        return this.irca.getRemoteType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRemoteCacheListener getInstance(IRemoteCacheAttributes irca) {
        if (instance == null) {
            Class clazz = class$org$apache$jcs$auxiliary$remote$RemoteCacheListener == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCacheListener = RemoteCacheListener.class$("org.apache.jcs.auxiliary.remote.RemoteCacheListener")) : class$org$apache$jcs$auxiliary$remote$RemoteCacheListener;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new RemoteCacheListener(irca);
                }
            }
        }
        return instance;
    }

    public void handlePut(ICacheElement cb) throws IOException {
        if (this.irca.getRemoveUponRemotePut()) {
            log.debug((Object)"PUTTING ELEMENT FROM REMOTE, (  invalidating ) ");
            this.handleRemove(cb.getCacheName(), cb.getKey());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"PUTTING ELEMENT FROM REMOTE, ( updating ) ");
                log.debug((Object)("cb = " + cb));
                ++this.puts;
                if (this.puts % 100 == 0) {
                    log.debug((Object)("puts = " + this.puts));
                }
            }
            this.getCacheManager();
            CompositeCache cache = cacheMgr.getCache(cb.getCacheName());
            cache.localUpdate(cb);
        }
    }

    public void handleRemove(String cacheName, Serializable key) throws IOException {
        if (log.isDebugEnabled()) {
            ++this.removes;
            if (this.removes % 100 == 0) {
                log.debug((Object)("removes = " + this.removes));
            }
            log.debug((Object)("handleRemove> cacheName=" + cacheName + ", key=" + key));
        }
        this.getCacheManager();
        CompositeCache cache = cacheMgr.getCache(cacheName);
        cache.localRemove(key);
    }

    public void handleRemoveAll(String cacheName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleRemoveAll> cacheName=" + cacheName));
        }
        this.getCacheManager();
        CompositeCache cache = cacheMgr.getCache(cacheName);
        cache.removeAll();
    }

    public void handleDispose(String cacheName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleDispose> cacheName=" + cacheName));
        }
        CompositeCacheManager cm = cacheMgr;
        cm.freeCache(cacheName, true);
    }

    protected void getCacheManager() {
        if (cacheMgr == null) {
            cacheMgr = CompositeCacheManager.getInstance();
            log.debug((Object)"had to get cacheMgr");
            if (log.isDebugEnabled()) {
                log.debug((Object)("cacheMgr = " + cacheMgr));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("already got cacheMgr = " + cacheMgr));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

