/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.memory.lru;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.group.GroupAttrName;
import org.apache.jcs.engine.control.group.GroupId;
import org.apache.jcs.engine.memory.AbstractMemoryCache;
import org.apache.jcs.engine.memory.lru.MemoryElementDescriptor;

public class LRUMemoryCache
extends AbstractMemoryCache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$engine$memory$lru$LRUMemoryCache == null ? (class$org$apache$jcs$engine$memory$lru$LRUMemoryCache = LRUMemoryCache.class$("org.apache.jcs.engine.memory.lru.LRUMemoryCache")) : class$org$apache$jcs$engine$memory$lru$LRUMemoryCache));
    private MemoryElementDescriptor first;
    private MemoryElementDescriptor last;
    static /* synthetic */ Class class$org$apache$jcs$engine$memory$lru$LRUMemoryCache;

    public synchronized void initialize(CompositeCache hub) {
        super.initialize(hub);
        log.info((Object)("initialized LRUMemoryCache for " + this.cacheName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(ICacheElement ce) throws IOException {
        int size;
        ce.getElementAttributes().setLastAccessTimeNow();
        this.addFirst(ce);
        MemoryElementDescriptor old = this.map.put(this.first.ce.getKey(), this.first);
        if (old != null && this.first.ce.getKey().equals(old.ce.getKey())) {
            this.removeNode(old);
        }
        if ((size = this.map.size()) < this.cattr.getMaxObjects()) {
            return;
        }
        log.debug((Object)"In memory limit reached, spooling");
        int chunkSizeCorrected = Math.min(size, this.chunkSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to spool to disk cache, map size: " + size + ", max objects: " + this.cattr.getMaxObjects() + ", items to spool: " + chunkSizeCorrected));
        }
        int i = 0;
        while (i < chunkSizeCorrected) {
            LRUMemoryCache lRUMemoryCache = this;
            synchronized (lRUMemoryCache) {
                if (this.last != null) {
                    if (this.last.ce == null) throw new Error("update: last.ce is null!");
                    this.cache.spoolToDisk(this.last.ce);
                    if (!this.map.containsKey(this.last.ce.getKey())) {
                        log.error((Object)("update: map does not contain key: " + this.last.ce.getKey()));
                        this.verifyCache();
                    }
                    if (this.map.remove(this.last.ce.getKey()) == null) {
                        log.warn((Object)("update: remove failed for key: " + this.last.ce.getKey()));
                        this.verifyCache();
                    }
                } else {
                    this.verifyCache();
                    throw new Error("update: last is null!");
                }
                this.removeNode(this.last);
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("update: After spool map size: " + this.map.size()));
        }
        if (this.map.size() == this.dumpCacheSize()) return;
        log.error((Object)("update: After spool, size mismatch: map.size() = " + this.map.size() + ", linked list size = " + this.dumpCacheSize()));
    }

    public synchronized void removeAll() throws IOException {
        this.map.clear();
        MemoryElementDescriptor me = this.first;
        while (me != null) {
            MemoryElementDescriptor next;
            if (me.prev != null) {
                me.prev = null;
            }
            me = next = me.next;
        }
        this.last = null;
        this.first = null;
    }

    public ICacheElement getQuiet(Serializable key) throws IOException {
        ICacheElement ce = null;
        MemoryElementDescriptor me = (MemoryElementDescriptor)this.map.get(key);
        if (me != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheName + ": LRUMemoryCache quiet hit for " + key));
            }
            ce = me.ce;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)(this.cacheName + ": LRUMemoryCache quiet miss for " + key));
        }
        return ce;
    }

    public synchronized ICacheElement get(Serializable key) throws IOException {
        MemoryElementDescriptor me;
        ICacheElement ce = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting item from cache " + this.cacheName + " for key " + key));
        }
        if ((me = (MemoryElementDescriptor)this.map.get(key)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheName + ": LRUMemoryCache hit for " + key));
            }
            ce = me.ce;
            ce.getElementAttributes().setLastAccessTimeNow();
            this.makeFirst(me);
        } else {
            log.debug((Object)(this.cacheName + ": LRUMemoryCache miss for " + key));
        }
        this.verifyCache();
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(Serializable key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing item for key: " + key));
        }
        boolean removed = false;
        if (key instanceof String && ((String)((Object)key)).endsWith(":")) {
            Map map = this.map;
            synchronized (map) {
                Iterator itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object k = entry.getKey();
                    if (!(k instanceof String) || !((String)k).startsWith(key.toString())) continue;
                    itr.remove();
                    this.removeNode((MemoryElementDescriptor)entry.getValue());
                    removed = true;
                }
            }
        } else if (key instanceof GroupId) {
            Map map = this.map;
            synchronized (map) {
                Iterator itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object k = entry.getKey();
                    if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(key)) continue;
                    itr.remove();
                    this.removeNode((MemoryElementDescriptor)entry.getValue());
                    removed = true;
                }
            }
        } else {
            MemoryElementDescriptor me = (MemoryElementDescriptor)this.map.remove(key);
            if (me != null) {
                this.removeNode(me);
                removed = true;
            }
        }
        return removed;
    }

    public Iterator getIterator() {
        return new IteratorWrapper(this.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getKeyArray() {
        LRUMemoryCache lRUMemoryCache = this;
        synchronized (lRUMemoryCache) {
            return this.map.keySet().toArray();
        }
    }

    private synchronized void removeNode(MemoryElementDescriptor me) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing node " + me.ce.getKey() + " from cache " + this.cacheName));
        }
        if (me.next == null) {
            if (me.prev == null) {
                if (me == this.first && me == this.last) {
                    this.last = null;
                    this.first = null;
                }
            } else {
                this.last = me.prev;
                this.last.next = null;
                me.prev = null;
            }
        } else if (me.prev == null) {
            this.first = me.next;
            this.first.prev = null;
            me.next = null;
        } else {
            me.prev.next = me.next;
            me.next.prev = me.prev;
            me.next = null;
            me.prev = null;
        }
    }

    private void addLast(CacheElement ce) {
        MemoryElementDescriptor me = new MemoryElementDescriptor(ce);
        if (this.first == null) {
            this.first = me;
        } else {
            this.last.next = me;
            me.prev = this.last;
        }
        this.last = me;
        this.verifyCache(ce.getKey());
    }

    private synchronized void addFirst(ICacheElement ce) {
        MemoryElementDescriptor me = new MemoryElementDescriptor(ce);
        if (this.last == null) {
            this.last = me;
        } else {
            this.first.prev = me;
            me.next = this.first;
        }
        this.first = me;
    }

    public void makeFirst(ICacheElement ce) {
        this.makeFirst(new MemoryElementDescriptor(ce));
    }

    public synchronized void makeFirst(MemoryElementDescriptor me) {
        if (me.prev == null) {
            return;
        }
        me.prev.next = me.next;
        if (me.next == null) {
            this.last = me.prev;
            this.last.next = null;
        } else {
            me.next.prev = me.prev;
        }
        this.first.prev = me;
        me.next = this.first;
        me.prev = null;
        this.first = me;
    }

    public void dumpMap() {
        log.debug((Object)"dumpingMap");
        Iterator itr = this.map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            MemoryElementDescriptor me = (MemoryElementDescriptor)e.getValue();
            log.debug((Object)("dumpMap> key=" + e.getKey() + ", val=" + me.ce.getVal()));
        }
    }

    public void dumpCacheEntries() {
        log.debug((Object)"dumpingCacheEntries");
        MemoryElementDescriptor me = this.first;
        while (me != null) {
            log.debug((Object)("dumpCacheEntries> key=" + me.ce.getKey() + ", val=" + me.ce.getVal()));
            me = me.next;
        }
    }

    private int dumpCacheSize() {
        int size = 0;
        MemoryElementDescriptor me = this.first;
        while (me != null) {
            ++size;
            me = me.next;
        }
        return size;
    }

    private void verifyCache() {
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean found = false;
        log.debug((Object)("verifycache[" + this.cacheName + "]: mapContains " + this.map.size() + " elements, linked list contains " + this.dumpCacheSize() + " elements"));
        log.debug((Object)"verifycache: checking linked list by key ");
        MemoryElementDescriptor li = this.first;
        while (li != null) {
            Serializable key = li.ce.getKey();
            if (!this.map.containsKey(key)) {
                log.error((Object)("verifycache[" + this.cacheName + "]: map does not contain key : " + li.ce.getKey()));
                log.error((Object)("li.hashcode=" + li.ce.getKey().hashCode()));
                log.error((Object)("key class=" + key.getClass()));
                log.error((Object)("key hashcode=" + key.hashCode()));
                log.error((Object)("key toString=" + key.toString()));
                if (key instanceof GroupAttrName) {
                    GroupAttrName name = (GroupAttrName)key;
                    log.error((Object)("GroupID hashcode=" + name.groupId.hashCode()));
                    log.error((Object)("GroupID.class=" + name.groupId.getClass()));
                    log.error((Object)("AttrName hashcode=" + name.attrName.hashCode()));
                    log.error((Object)("AttrName.class=" + name.attrName.getClass()));
                }
                this.dumpMap();
            } else if (this.map.get(li.ce.getKey()) == null) {
                log.error((Object)("verifycache[" + this.cacheName + "]: linked list retrieval returned null for key: " + li.ce.getKey()));
            }
            li = li.next;
        }
        log.debug((Object)"verifycache: checking linked list by value ");
        MemoryElementDescriptor li3 = this.first;
        while (li3 != null) {
            if (!this.map.containsValue(li3)) {
                log.error((Object)("verifycache[" + this.cacheName + "]: map does not contain value : " + li3));
                this.dumpMap();
            }
            li3 = li3.next;
        }
        log.debug((Object)"verifycache: checking via keysets!");
        Iterator itr2 = this.map.keySet().iterator();
        while (itr2.hasNext()) {
            found = false;
            Serializable val = null;
            try {
                val = (Serializable)itr2.next();
            }
            catch (NoSuchElementException nse) {
                log.error((Object)"verifycache: no such element exception");
            }
            MemoryElementDescriptor li2 = this.first;
            while (li2 != null) {
                if (val.equals(li2.ce.getKey())) {
                    found = true;
                    break;
                }
                li2 = li2.next;
            }
            if (found) continue;
            log.error((Object)("verifycache[" + this.cacheName + "]: key not found in list : " + val));
            this.dumpCacheEntries();
            if (this.map.containsKey(val)) {
                log.error((Object)"verifycache: map contains key");
                continue;
            }
            log.error((Object)"verifycache: map does NOT contain key, what the HECK!");
        }
    }

    private void verifyCache(Serializable key) {
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean found = false;
        MemoryElementDescriptor li = this.first;
        while (li != null) {
            if (li.ce.getKey() == key) {
                found = true;
                log.debug((Object)("verifycache(key) key match: " + key));
                break;
            }
            li = li.next;
        }
        if (!found) {
            log.error((Object)("verifycache(key)[" + this.cacheName + "], couldn't find key! : " + key));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class MapEntryWrapper
    implements Map.Entry {
        private final Map.Entry e;

        private MapEntryWrapper(Map.Entry e) {
            this.e = e;
        }

        public boolean equals(Object o) {
            return this.e.equals(o);
        }

        public Object getKey() {
            return this.e.getKey();
        }

        public Object getValue() {
            return ((MemoryElementDescriptor)this.e.getValue()).ce;
        }

        public int hashCode() {
            return this.e.hashCode();
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("Use normal cache methods to alter the contents of the cache.");
        }
    }

    public class IteratorWrapper
    implements Iterator {
        private final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$engine$memory$lru$LRUMemoryCache == null ? (class$org$apache$jcs$engine$memory$lru$LRUMemoryCache = LRUMemoryCache.class$("org.apache.jcs.engine.memory.lru.LRUMemoryCache")) : class$org$apache$jcs$engine$memory$lru$LRUMemoryCache));
        private final Iterator i;

        private IteratorWrapper(Map m) {
            this.i = m.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return new MapEntryWrapper((Map.Entry)this.i.next());
        }

        public void remove() {
            this.i.remove();
        }

        public boolean equals(Object o) {
            return this.i.equals(o);
        }

        public int hashCode() {
            return this.i.hashCode();
        }
    }
}

