/*
 * Decompiled with CFR 0.152.
 */
package middlegen.plugins.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import middlegen.ColumnMap;
import middlegen.RelationshipRole;
import middlegen.Table;
import middlegen.Util;
import middlegen.javax.JavaTable;
import middlegen.plugins.hibernate.HibernateColumn;
import middlegen.plugins.hibernate.HibernatePlugin;
import middlegen.plugins.hibernate.predicates.relation.NotTargetInOriginPK;
import middlegen.plugins.hibernate.predicates.relation.TargetInOriginPK;
import middlegen.plugins.hibernate.predicates.relation.TargetOneToOneFKRoles;
import middlegen.predicates.column.PrimaryKey;
import middlegen.util.BooleanNode;

public class HibernateTable
extends JavaTable {
    private BooleanNode _lifecycle;
    private BooleanNode _validatable;
    private BooleanNode _proxy;
    private BooleanNode _mutable;
    private BooleanNode _dynamicUpdate;
    private String _destinationClassName;
    private String _databaseSchema;
    private String _persister;
    private String _classDescription;
    private String _classScope;
    private String _extends;
    private ArrayList _implements;
    private BooleanNode _pkInnerClass;
    private String _keyGenerator;
    private String _keyGeneratorArg;

    public HibernateTable(Table table) {
        super(table);
    }

    public void setImplementLifecycle(boolean bl) {
        this.setPrefsValue("lifecycle", Util.string((boolean)bl));
        this._lifecycle.setValue(bl);
    }

    public void setImplementValidatable(boolean bl) {
        this.setPrefsValue("validatable", Util.string((boolean)bl));
        this._validatable.setValue(bl);
    }

    public void setProxy(boolean bl) {
        this.setPrefsValue("proxy", Util.string((boolean)bl));
        this._proxy.setValue(bl);
    }

    public void setMutable(boolean bl) {
        this.setPrefsValue("mutable", Util.string((boolean)bl));
        this._mutable.setValue(bl);
    }

    public void setDynamicUpdate(boolean bl) {
        this.setPrefsValue("dynamicUpdate", Util.string((boolean)bl));
        this._dynamicUpdate.setValue(bl);
    }

    public void setDestinationClassName(String string) {
        this.setPrefsValue("destinationClassName", string);
        this._destinationClassName = string;
    }

    public void setDatabaseSchema(String string) {
        this.setPrefsValue("databaseSchema", string);
        this._databaseSchema = string;
    }

    public void setPersister(String string) {
        this.setPrefsValue("persister", string);
        this._persister = string;
    }

    public void setClassDescription(String string) {
        this.setPrefsValue("description", string);
        this._classDescription = string;
    }

    public void setClassScope(String string) {
        this.setPrefsValue("classscope", string);
        this._classScope = string;
    }

    public void setExtends(String string) {
        this.setPrefsValue("extends", string);
        this._extends = string;
    }

    public void setImplements(ArrayList arrayList) {
        this.setPrefsValue("implements", this.encodeImplementsStr(arrayList));
        this._implements = arrayList;
    }

    public void setKeyGenerator(String string) {
        this.setPrefsValue("keygenerator", string);
        this._keyGenerator = string;
    }

    public void setKeyGeneratorArg(String string) {
        this.setPrefsValue("keygeneratorarg", string);
        this._keyGeneratorArg = string;
    }

    public String getDestinationClassName() {
        return this._destinationClassName;
    }

    public String getCompoundKeyDestinationClassName() {
        return this._destinationClassName + "PK";
    }

    public String getDatabaseSchema() {
        return this._databaseSchema.trim();
    }

    public String getPersister() {
        return this._persister.trim();
    }

    public String getClassDescription() {
        return this._classDescription.trim();
    }

    public String getClassScope() {
        return this._classScope.trim();
    }

    public String getExtends() {
        return this._extends.trim();
    }

    public HibernateColumn getVersioningField() {
        Collection collection = this.getColumns();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            HibernateColumn hibernateColumn = (HibernateColumn)((Object)iterator.next());
            if (!hibernateColumn.getColumnSpecialty().equals("version") && !hibernateColumn.getColumnSpecialty().equals("timestamp")) continue;
            return hibernateColumn;
        }
        return null;
    }

    public boolean isImplementLifecycle() {
        return this._lifecycle.isCompletelyTrue();
    }

    public boolean isImplementValidatable() {
        return this._validatable.isCompletelyTrue();
    }

    public boolean isProxy() {
        return this._proxy.isCompletelyTrue();
    }

    public boolean isMutable() {
        return this._mutable.isCompletelyTrue();
    }

    public boolean isDynamicUpdate() {
        return this._dynamicUpdate.isCompletelyTrue();
    }

    public boolean isSchemaName() {
        return this._databaseSchema != null && this._databaseSchema.trim().length() != 0;
    }

    public boolean isPersisterName() {
        return this._persister != null && this._persister.trim().length() != 0;
    }

    public boolean isClassDescriptionName() {
        return this._classDescription != null && this._classDescription.trim().length() != 0;
    }

    public boolean isClassScopeName() {
        return this._classScope != null && this._classScope.trim().length() != 0 && !this._classScope.equals("public");
    }

    public boolean isExtendsName() {
        return this._extends != null && this._extends.trim().length() != 0;
    }

    public boolean isCompositeKey() {
        return this.getPkColumn() == null;
    }

    public boolean isVersioningPresent() {
        return this.getVersioningField() != null;
    }

    public BooleanNode getLifecycleNode() {
        return this._lifecycle;
    }

    public BooleanNode getValidatableNode() {
        return this._validatable;
    }

    public BooleanNode getProxyNode() {
        return this._proxy;
    }

    public BooleanNode getDynamicUpdateNode() {
        return this._dynamicUpdate;
    }

    public BooleanNode getMutableNode() {
        return this._mutable;
    }

    public ArrayList getImplements() {
        return this._implements;
    }

    public String getKeyGenerator() {
        return this._keyGenerator.trim();
    }

    public String getKeyGeneratorArg() {
        return this._keyGeneratorArg.trim();
    }

    public String getGeneratorUnsavedValue() {
        if ("identity".equals(this._keyGenerator)) {
            return "0";
        }
        return null;
    }

    public boolean isGeneratorRequiresParams() {
        return "hilo".equals(this._keyGenerator) || "seqhilo".equals(this._keyGenerator) || "sequence".equals(this._keyGenerator);
    }

    public Collection getPrimaryKeyRoles() {
        return this.getRelationshipRoles(TargetInOriginPK.getInstance());
    }

    public Collection getNotPrimaryKeyRoles() {
        return this.getRelationshipRoles(NotTargetInOriginPK.getInstance());
    }

    public Collection getChildSidePrimaryKeyOnlyOneToOneRoles() {
        return this.getRelationshipRoles(TargetOneToOneFKRoles.getInstance());
    }

    public Collection getColsInactive(RelationshipRole relationshipRole) {
        ArrayList<HibernateColumn> arrayList = new ArrayList<HibernateColumn>();
        ColumnMap[] columnMapArray = relationshipRole.getTargetRole().getColumnMaps();
        for (int i = 0; i < columnMapArray.length; ++i) {
            HibernateColumn hibernateColumn = (HibernateColumn)this.getColumn(columnMapArray[i].getForeignKey());
            arrayList.add(hibernateColumn);
        }
        return arrayList;
    }

    public boolean isRoleOneToOnePrimaryKeys(RelationshipRole relationshipRole, HibernateTable hibernateTable) {
        int n;
        boolean bl = true;
        ColumnMap[] columnMapArray = relationshipRole.getColumnMaps();
        if (columnMapArray.length <= 0) {
            return false;
        }
        int n2 = columnMapArray.length;
        for (n = 0; n < columnMapArray.length; ++n) {
            HibernateColumn hibernateColumn = (HibernateColumn)this.getColumn(columnMapArray[n].getPrimaryKey());
            HibernateColumn hibernateColumn2 = (HibernateColumn)hibernateTable.getColumn(columnMapArray[n].getForeignKey());
            if (hibernateColumn2.isPk() && hibernateColumn.isPk()) continue;
            return false;
        }
        n = this.getColumns(PrimaryKey.getInstance()).size();
        if (n != n2) {
            return false;
        }
        int n3 = hibernateTable.getColumns(PrimaryKey.getInstance()).size();
        if (n3 != n2) {
            return false;
        }
        return bl;
    }

    public String getCardinalityValue(RelationshipRole relationshipRole) {
        if (relationshipRole.getRelation().isMany2Many()) {
            return "many-to-many";
        }
        if (relationshipRole.getRelation().isOne2One()) {
            return "one-to-one";
        }
        if (relationshipRole.isTargetMany()) {
            return "one-to-many";
        }
        return "many-to-one";
    }

    public String getDirectionality(RelationshipRole relationshipRole) {
        if (relationshipRole.getRelation().isBidirectional()) {
            return "bi-directional";
        }
        return "uni-directional";
    }

    protected void init() {
        super.init();
        HibernatePlugin hibernatePlugin = (HibernatePlugin)this.getPlugin();
        this._lifecycle = hibernatePlugin.getLifecycle().createChild(hibernatePlugin.isLifecycle());
        if (this.getPrefsValue("lifecycle") != null) {
            this.setImplementLifecycle(Util.bool((String)this.getPrefsValue("lifecycle")));
        }
        this._validatable = hibernatePlugin.getValidatable().createChild(hibernatePlugin.isValidatable());
        if (this.getPrefsValue("validatable") != null) {
            this.setImplementValidatable(Util.bool((String)this.getPrefsValue("validatable")));
        }
        this._proxy = hibernatePlugin.getProxy().createChild(hibernatePlugin.isProxy());
        if (this.getPrefsValue("proxy") != null) {
            this.setProxy(Util.bool((String)this.getPrefsValue("proxy")));
        }
        this._mutable = hibernatePlugin.getMutable().createChild(hibernatePlugin.isMutable());
        if (this.getPrefsValue("mutable") != null) {
            this.setMutable(Util.bool((String)this.getPrefsValue("mutable")));
        }
        this._dynamicUpdate = hibernatePlugin.getDynamicUpdate().createChild(hibernatePlugin.isDynamicUpdate());
        if (this.getPrefsValue("dynamicUpdate") != null) {
            this.setDynamicUpdate(Util.bool((String)this.getPrefsValue("dynamicUpdate")));
        }
        this._databaseSchema = hibernatePlugin.getDatabaseSchema();
        if (this.getPrefsValue("databaseSchema") != null) {
            this.setDatabaseSchema(this.getPrefsValue("databaseSchema"));
        }
        this._classDescription = hibernatePlugin.getClassDescription();
        if (this.getPrefsValue("description") != null) {
            this.setClassDescription(this.getPrefsValue("description"));
        }
        this._classScope = hibernatePlugin.getClassScope();
        if (this.getPrefsValue("classscope") != null) {
            this.setClassScope(this.getPrefsValue("classscope"));
        }
        this._extends = hibernatePlugin.getExtends();
        if (this.getPrefsValue("extends") != null) {
            this.setExtends(this.getPrefsValue("extends"));
        }
        this._implements = hibernatePlugin.getImplements();
        if (this.getPrefsValue("implements") != null) {
            this.setImplements(this.decodeImplementsStr(this.getPrefsValue("implements"), this._implements));
        }
        this._persister = hibernatePlugin.getPersister();
        if (this.getPrefsValue("persister") != null) {
            this.setPersister(this.getPrefsValue("persister"));
        }
        this._destinationClassName = this.getPrefsValue("destinationClassName") != null ? this.getPrefsValue("destinationClassName") : this.getBaseClassName() + hibernatePlugin.getBeansuffix();
        this._keyGenerator = "assigned";
        if (this.getPrefsValue("keygenerator") != null) {
            this._keyGenerator = this.getPrefsValue("keygenerator");
        }
        this._keyGeneratorArg = "";
        if (this.getPrefsValue("keygeneratorarg") != null) {
            this._keyGeneratorArg = this.getPrefsValue("keygeneratorarg");
        }
    }

    private String encodeImplementsStr(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append((String)arrayList.get(i));
            if (i + 1 >= arrayList.size()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private ArrayList decodeImplementsStr(String string, ArrayList arrayList) {
        ArrayList<String> arrayList2 = arrayList;
        if (string != null && string.length() != 0) {
            arrayList2 = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.length() <= 0) continue;
                arrayList2.add(string2);
            }
        }
        return arrayList2;
    }
}

