/*
 * Decompiled with CFR 0.152.
 */
package middlegen.plugins.hibernate.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import middlegen.Column;
import middlegen.javax.Sql2Java;
import middlegen.plugins.hibernate.HibernateColumn;
import middlegen.plugins.hibernate.HibernateTable;
import middlegen.swing.BooleanNodeCheckBox;
import middlegen.swing.JColumnSettingsPanel;

public class JHibernateColumnSettingsPanel
extends JColumnSettingsPanel {
    protected HibernateColumn[] _currentColumns;
    private final JLabel _columnNameLabel = new JLabel("  Java property name");
    private final JTextField _columnNameField = new JTextField();
    private final JLabel _columnTypeLabel = new JLabel("  Java type");
    private final JComboBox _columnTypeCombo = new JComboBox();
    private final JRadioButton _publicGetRadioButton = new JRadioButton("public");
    private final JRadioButton _protectedGetRadioButton = new JRadioButton("protected");
    private final JRadioButton _privateGetRadioButton = new JRadioButton("private");
    private final JRadioButton _publicSetRadioButton = new JRadioButton("public");
    private final JRadioButton _protectedSetRadioButton = new JRadioButton("protected");
    private final JRadioButton _privateSetRadioButton = new JRadioButton("private");
    private final JRadioButton _publicFieldRadioButton = new JRadioButton("public");
    private final JRadioButton _protectedFieldRadioButton = new JRadioButton("protected");
    private final JRadioButton _privateFieldRadioButton = new JRadioButton("private");
    private final JLabel _columnSpecialtyLabel = new JLabel("  Hibernate mapping specialty");
    private final JComboBox _columnSpecialtyCombo = new JComboBox();
    private final BooleanNodeCheckBox _columnUpdateableCheckBox = new BooleanNodeCheckBox("Column updateable", null);
    private final BooleanNodeCheckBox _columnInsertableCheckBox = new BooleanNodeCheckBox("Column insertable", null);
    private final JLabel _fieldDescriptionLabel = new JLabel("  Field description");
    private final JTextField _fieldDescriptionField = new JTextField();
    private final JLabel _propertyGetScopeLabel = new JLabel("  Property get scope");
    private final JLabel _propertySetScopeLabel = new JLabel("  Property set scope");
    private final JLabel _fieldScopeLabel = new JLabel("  Field set scope");
    private final BooleanNodeCheckBox _includeInTostringCheckBox = new BooleanNodeCheckBox("Include in toString", null);
    private final BooleanNodeCheckBox _genPropertyCheckBox = new BooleanNodeCheckBox("Generate the property", null);
    private final JLabel _beanPropertyTypeLabel = new JLabel("  Bean constraint property type");
    private final JComboBox _beanPropertyTypeCombo = new JComboBox();
    private final DocumentListener _fieldDescriptionDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                JHibernateColumnSettingsPanel.this._currentColumns[i].setFieldDescription(JHibernateColumnSettingsPanel.this._fieldDescriptionField.getText());
            }
        }
    };
    private final ActionListener _comboListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            this.update();
        }

        private void update() {
            String string = (String)JHibernateColumnSettingsPanel.this._columnTypeCombo.getSelectedItem();
            if (string != null) {
                for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                    String[] stringArray = Sql2Java.getJavaTypes((int)JHibernateColumnSettingsPanel.this._currentColumns[i].getSqlType());
                    boolean bl = false;
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!stringArray[j].equals(string)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        JHibernateColumnSettingsPanel.this._currentColumns[i].setJavaType(string);
                        continue;
                    }
                    JHibernateColumnSettingsPanel.this._currentColumns[i].setJavaType(Sql2Java.getPreferredJavaType((int)JHibernateColumnSettingsPanel.this._currentColumns[i].getSqlType(), (int)0, (int)0));
                }
            }
        }
    };
    private final ActionListener _beanComboListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            this.update();
        }

        private void update() {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                String string = (String)JHibernateColumnSettingsPanel.this._beanPropertyTypeCombo.getSelectedItem();
                if (string == null) continue;
                JHibernateColumnSettingsPanel.this._currentColumns[i].setBeanPropertyType(string);
            }
        }
    };
    private final ActionListener _columnSpecialtyComboListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            this.update();
        }

        private void update() {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                String string = (String)JHibernateColumnSettingsPanel.this._columnSpecialtyCombo.getSelectedItem();
                if (string == null) continue;
                JHibernateColumnSettingsPanel.this._currentColumns[i].setColumnSpecialty(string);
            }
        }
    };
    private final ActionListener toggleBtnUpdateableAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                JHibernateColumnSettingsPanel.this._currentColumns[i].setUpdateable(((BooleanNodeCheckBox)actionEvent.getSource()).isSelected());
            }
        }
    };
    private final ActionListener toggleBtnInsertableAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                JHibernateColumnSettingsPanel.this._currentColumns[i].setInsertable(((BooleanNodeCheckBox)actionEvent.getSource()).isSelected());
            }
        }
    };
    private final ActionListener toggleBtnIncludeToStringAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                JHibernateColumnSettingsPanel.this._currentColumns[i].setIncludeToString(((BooleanNodeCheckBox)actionEvent.getSource()).isSelected());
            }
        }
    };
    private final ActionListener toggleBtnGenPropertyAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                JHibernateColumnSettingsPanel.this._currentColumns[i].setGenProperty(((BooleanNodeCheckBox)actionEvent.getSource()).isSelected());
            }
        }
    };

    public JHibernateColumnSettingsPanel() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.initComponents();
        this.addComponents();
        this.assignAllListeners();
    }

    public void setColumns(Column[] columnArray) {
        boolean bl;
        this.deassignAllListeners();
        this._currentColumns = new HibernateColumn[columnArray.length];
        for (bl = false; bl < columnArray.length; bl += 1) {
            this._currentColumns[bl] = (HibernateColumn)columnArray[bl];
        }
        boolean bl2 = bl = this._currentColumns.length == 1;
        if (this._currentColumns.length >= 1) {
            this._columnUpdateableCheckBox.setBooleanNode(this._currentColumns[0].getUpdateableNode());
            this._columnInsertableCheckBox.setBooleanNode(this._currentColumns[0].getInsertableNode());
            this._includeInTostringCheckBox.setBooleanNode(this._currentColumns[0].getIncludeToStringNode());
            this._genPropertyCheckBox.setBooleanNode(this._currentColumns[0].getGenPropertyNode());
            this._fieldDescriptionField.setText(this._currentColumns[0].getFieldDescription());
            this._beanPropertyTypeCombo.setSelectedItem(this._currentColumns[0].getBeanPropertyType());
            this.setFieldScope();
            this.setFieldGetScope();
            this.setFieldSetScope();
        }
        this._columnNameField.setEnabled(bl);
        this._genPropertyCheckBox.setEnabled(bl);
        if (bl) {
            this._columnNameField.setText(this._currentColumns[0].getVariableName());
        } else {
            this._columnNameField.setText("");
        }
        this.setHibernateJavaTypeCombo();
        this.setHibernateSpecialtyCombo();
        this.assignAllListeners();
    }

    protected void initComponents() {
        String[] stringArray = new String[]{"key", "compound key", "version", "timestamp", "property"};
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
        this._columnSpecialtyCombo.setModel(defaultComboBoxModel);
        this._columnSpecialtyCombo.setEditable(false);
        String[] stringArray2 = new String[]{"unbound", "bound", "constrained"};
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(stringArray2);
        this._beanPropertyTypeCombo.setModel(defaultComboBoxModel2);
        this._beanPropertyTypeCombo.setEditable(false);
        this._columnNameField.setEditable(false);
    }

    protected void addComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder("Column Mapping Attributes"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Domain Property Meta Attributes"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(0, 2, 0, 2));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(0, 2, 4, 2));
        jPanel3.add(this._columnSpecialtyLabel);
        jPanel3.add(this._columnSpecialtyCombo);
        jPanel3.add(this._columnNameLabel);
        jPanel3.add(this._columnNameField);
        jPanel3.add(this._columnTypeLabel);
        jPanel3.add(this._columnTypeCombo);
        jPanel4.add((Component)this._columnUpdateableCheckBox);
        jPanel4.add((Component)this._columnInsertableCheckBox);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel5.add(this._fieldDescriptionLabel);
        jPanel5.add(this._fieldDescriptionField);
        jPanel6.add(this._propertyGetScopeLabel);
        jPanel6.add(this.BuildTableGetScopePanel());
        jPanel6.add(this._propertySetScopeLabel);
        jPanel6.add(this.BuildTableSetScopePanel());
        jPanel6.add(this._fieldScopeLabel);
        jPanel6.add(this.BuildTableFieldScopePanel());
        jPanel7.add(this._beanPropertyTypeLabel);
        jPanel7.add(this._beanPropertyTypeCombo);
        jPanel8.add((Component)this._includeInTostringCheckBox);
        jPanel8.add((Component)this._genPropertyCheckBox);
        jPanel2.add(jPanel5);
        jPanel2.add(jPanel6);
        jPanel2.add(jPanel7);
        jPanel2.add(jPanel8);
        this.add(jPanel);
        this.add(jPanel2);
    }

    private void setHibernateJavaTypeCombo() {
        this._columnTypeCombo.setEnabled(true);
        this._columnTypeCombo.removeAllItems();
        if (this._currentColumns[0].isPk() && ((HibernateTable)this._currentColumns[0].getTable()).isCompositeKey()) {
            if (this._currentColumns.length > 1) {
                this._columnTypeCombo.setEnabled(false);
            } else {
                this._columnTypeLabel.setText("  Java type   (" + ((HibernateTable)this._currentColumns[0].getTable()).getCompoundKeyDestinationClassName() + ")");
            }
        } else {
            this._columnTypeLabel.setText("  Java type");
        }
        String string = this._currentColumns[0].getJavaType();
        String[] stringArray = Sql2Java.getJavaTypes((int)this._currentColumns[0].getSqlType());
        for (int i = 0; i < stringArray.length; ++i) {
            this._columnTypeCombo.addItem(stringArray[i]);
        }
        this._columnTypeCombo.setSelectedItem(string);
    }

    private void setHibernateSpecialtyCombo() {
        this._columnSpecialtyCombo.setEnabled(true);
        this._columnSpecialtyCombo.removeAllItems();
        if (this._currentColumns.length == 1) {
            if (this._currentColumns[0].isPk()) {
                if (((HibernateTable)this._currentColumns[0].getTable()).isCompositeKey()) {
                    this._columnSpecialtyCombo.addItem("compound key");
                } else {
                    this._columnSpecialtyCombo.addItem("key");
                }
            } else if (this._currentColumns[0].isFk()) {
                this._columnSpecialtyCombo.addItem("foreign key");
            } else {
                String string = Sql2Java.getPreferredJavaType((int)this._currentColumns[0].getSqlType(), (int)0, (int)0);
                this._columnSpecialtyCombo.addItem("property");
                if (string.equals("long") || string.equals("int") || string.equals("short")) {
                    this._columnSpecialtyCombo.addItem("version");
                } else if (string.equals("java.sql.Timestamp")) {
                    this._columnSpecialtyCombo.addItem("timestamp");
                }
            }
            this._columnSpecialtyCombo.setSelectedItem(this._currentColumns[0].getColumnSpecialty());
            this._currentColumns[0].setColumnSpecialty((String)this._columnSpecialtyCombo.getSelectedItem());
        } else {
            this._columnSpecialtyCombo.addItem("property");
            this._columnSpecialtyCombo.setEnabled(false);
        }
    }

    private void setFieldScope() {
        this._publicFieldRadioButton.setSelected(this._currentColumns[0].getFieldScope().equals("public"));
        this._protectedFieldRadioButton.setSelected(this._currentColumns[0].getFieldScope().equals("protected"));
        this._privateFieldRadioButton.setSelected(this._currentColumns[0].getFieldScope().equals("private"));
    }

    private void setFieldGetScope() {
        this._publicGetRadioButton.setSelected(this._currentColumns[0].getFieldGetScope().equals("public"));
        this._protectedGetRadioButton.setSelected(this._currentColumns[0].getFieldGetScope().equals("protected"));
        this._privateGetRadioButton.setSelected(this._currentColumns[0].getFieldGetScope().equals("private"));
    }

    private void setFieldSetScope() {
        this._publicSetRadioButton.setSelected(this._currentColumns[0].getFieldSetScope().equals("public"));
        this._protectedSetRadioButton.setSelected(this._currentColumns[0].getFieldSetScope().equals("protected"));
        this._privateSetRadioButton.setSelected(this._currentColumns[0].getFieldSetScope().equals("private"));
    }

    private JPanel BuildTableGetScopePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._publicGetRadioButton);
        buttonGroup.add(this._protectedGetRadioButton);
        buttonGroup.add(this._privateGetRadioButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                    JHibernateColumnSettingsPanel.this._currentColumns[i].setFieldGetScope(actionEvent.getActionCommand());
                }
            }
        };
        this._publicGetRadioButton.setActionCommand("public");
        this._publicGetRadioButton.addActionListener(actionListener);
        this._protectedGetRadioButton.addActionListener(actionListener);
        this._protectedGetRadioButton.setActionCommand("protected");
        this._privateGetRadioButton.addActionListener(actionListener);
        this._privateGetRadioButton.setActionCommand("private");
        jPanel.add(this._publicGetRadioButton);
        jPanel.add(this._protectedGetRadioButton);
        jPanel.add(this._privateGetRadioButton);
        return jPanel;
    }

    private JPanel BuildTableSetScopePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._publicSetRadioButton);
        buttonGroup.add(this._protectedSetRadioButton);
        buttonGroup.add(this._privateSetRadioButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                    JHibernateColumnSettingsPanel.this._currentColumns[i].setFieldSetScope(actionEvent.getActionCommand());
                }
            }
        };
        this._publicSetRadioButton.setActionCommand("public");
        this._publicSetRadioButton.addActionListener(actionListener);
        this._protectedSetRadioButton.addActionListener(actionListener);
        this._protectedSetRadioButton.setActionCommand("protected");
        this._privateSetRadioButton.addActionListener(actionListener);
        this._privateSetRadioButton.setActionCommand("private");
        jPanel.add(this._publicSetRadioButton);
        jPanel.add(this._protectedSetRadioButton);
        jPanel.add(this._privateSetRadioButton);
        return jPanel;
    }

    private JPanel BuildTableFieldScopePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._publicFieldRadioButton);
        buttonGroup.add(this._protectedFieldRadioButton);
        buttonGroup.add(this._privateFieldRadioButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < JHibernateColumnSettingsPanel.this._currentColumns.length; ++i) {
                    JHibernateColumnSettingsPanel.this._currentColumns[i].setFieldScope(actionEvent.getActionCommand());
                }
            }
        };
        this._publicFieldRadioButton.setActionCommand("public");
        this._publicFieldRadioButton.addActionListener(actionListener);
        this._protectedFieldRadioButton.addActionListener(actionListener);
        this._protectedFieldRadioButton.setActionCommand("protected");
        this._privateFieldRadioButton.addActionListener(actionListener);
        this._privateFieldRadioButton.setActionCommand("private");
        jPanel.add(this._publicFieldRadioButton);
        jPanel.add(this._protectedFieldRadioButton);
        jPanel.add(this._privateFieldRadioButton);
        return jPanel;
    }

    private Object[] common(Object[][] objectArray) {
        Integer n;
        Object object;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            for (int j = 0; j < ((Object[])object).length; ++j) {
                n = (Integer)hashMap.get(object[j]);
                if (n == null) {
                    n = new Integer(0);
                }
                hashMap.put(object[j], new Integer(n + 1));
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (objectArray.length > 1) {
            arrayList.add("");
        }
        object = hashMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            n = (Integer)entry.getValue();
            if (n != objectArray.length) continue;
            arrayList.add((String)entry.getKey());
        }
        Object[] objectArray2 = arrayList.toArray();
        Arrays.sort(objectArray2, Sql2Java.getTypeComparator());
        return objectArray2;
    }

    private void assignAllListeners() {
        this._columnTypeCombo.addActionListener(this._comboListener);
        this._fieldDescriptionField.getDocument().addDocumentListener(this._fieldDescriptionDocumentListener);
        this._beanPropertyTypeCombo.addActionListener(this._beanComboListener);
        this._columnSpecialtyCombo.addActionListener(this._columnSpecialtyComboListener);
        this._columnUpdateableCheckBox.addActionListener(this.toggleBtnUpdateableAction);
        this._columnInsertableCheckBox.addActionListener(this.toggleBtnInsertableAction);
        this._includeInTostringCheckBox.addActionListener(this.toggleBtnIncludeToStringAction);
        this._genPropertyCheckBox.addActionListener(this.toggleBtnGenPropertyAction);
    }

    private void deassignAllListeners() {
        this._columnTypeCombo.removeActionListener(this._comboListener);
        this._fieldDescriptionField.getDocument().removeDocumentListener(this._fieldDescriptionDocumentListener);
        this._beanPropertyTypeCombo.removeActionListener(this._beanComboListener);
        this._columnSpecialtyCombo.removeActionListener(this._columnSpecialtyComboListener);
        this._columnUpdateableCheckBox.removeActionListener(this.toggleBtnUpdateableAction);
        this._columnInsertableCheckBox.removeActionListener(this.toggleBtnInsertableAction);
        this._includeInTostringCheckBox.removeActionListener(this.toggleBtnIncludeToStringAction);
        this._genPropertyCheckBox.removeActionListener(this.toggleBtnGenPropertyAction);
    }
}

