/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.sql.DataSource;
import middlegen.Database;
import middlegen.MiddlegenException;

public class JNDIDatabase
implements Database {
    private final String _initialContextFactory;
    private final String _providerURL;
    private final String _dataSourceJNDIName;

    public JNDIDatabase(String initialContextFactory, String providerURL, String dataSourceJNDIName) {
        if (initialContextFactory == null) {
            throw new IllegalArgumentException("initialContextFactory can't be null");
        }
        if (providerURL == null) {
            throw new IllegalArgumentException("providerURL can't be null");
        }
        if (dataSourceJNDIName == null) {
            throw new IllegalArgumentException("dataSourceJNDIName can't be null");
        }
        this._initialContextFactory = initialContextFactory;
        this._providerURL = providerURL;
        this._dataSourceJNDIName = dataSourceJNDIName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection getConnection() throws MiddlegenException {
        InitialContext ctx = null;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("java.naming.factory.initial", this._initialContextFactory);
        ht.put("java.naming.provider.url", this._providerURL);
        try {
            try {
                Connection connection;
                ctx = new InitialContext(ht);
                DataSource ds = (DataSource)ctx.lookup(this._dataSourceJNDIName);
                Connection connection2 = connection = ds.getConnection();
                Object var5_10 = null;
                try {
                    ctx.close();
                    return connection2;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return connection2;
            }
            catch (NoInitialContextException e) {
                e.printStackTrace();
                throw new MiddlegenException("You should put your JNDI implementation classes on the system CLASSPATH:" + e.getMessage());
            }
            catch (CommunicationException e) {
                e.printStackTrace();
                throw new MiddlegenException("Is your JNDI server running?:" + e.getMessage());
            }
            catch (NamingException e) {
                e.printStackTrace();
                throw new MiddlegenException("Couldn't look up database using JNDI:" + e.getMessage());
            }
            catch (SQLException e) {
                throw new MiddlegenException("Couldn't get Connection:" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            try {}
            catch (Exception e) {
                throw throwable;
            }
            ctx.close();
            throw throwable;
        }
    }
}

