/*
 * Decompiled with CFR 0.152.
 */
package middlegen.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import middlegen.Column;
import middlegen.DbTable;
import middlegen.Middlegen;
import middlegen.Relation;
import middlegen.Table;
import middlegen.swing.JSettingsTabPane;
import middlegen.swing.JTablePanel;
import middlegen.swing.MiddlegenLayout;
import middlegen.swing.RelationLine;
import middlegen.swing.SettingsPanelCommander;
import org.apache.log4j.Category;

public class JDatabasePanel
extends JPanel {
    private Map _table2JTableMap = new HashMap();
    private Collection _lines = new ArrayList();
    private Collection _tablePanels = new ArrayList();
    private Map _ejbConfigurationMap = new HashMap();
    private RelationBuilder _relationBuilder = new RelationBuilder();
    private final ListSelectionListener _columnSelectionListener;
    private RelationLine _selectedRelationLine = null;
    private static Category _log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.swing.JDatabasePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public JDatabasePanel(final JSettingsTabPane settingsTabPane, final JLabel header) {
        this.printHints();
        this._columnSelectionListener = new SettingsPanelCommander(settingsTabPane, header);
        this.setLayout(new MiddlegenLayout());
        MouseInputAdapter mouse = new MouseInputAdapter(){
            private JTablePanel _pressed = null;
            private int _deltaX;
            private int _deltaY;

            public void mousePressed(MouseEvent evt) {
                JDatabasePanel.this._selectedRelationLine = null;
                Component c = JDatabasePanel.this.getComponentAt(evt.getPoint());
                if (c != null && c instanceof JTablePanel) {
                    this._pressed = (JTablePanel)c;
                    this._deltaX = evt.getX() - this._pressed.getX();
                    this._deltaY = evt.getY() - this._pressed.getY();
                    Set tableSet = JDatabasePanel.this._table2JTableMap.entrySet();
                    Iterator i = tableSet.iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        JTablePanel tablePanel = (JTablePanel)entry.getValue();
                        if (tablePanel == this._pressed) {
                            tablePanel.setSelected(true);
                            settingsTabPane.setTable(tablePanel.getTable());
                            header.setText(tablePanel.getTable().getSchemaPrefixedSqlName());
                            continue;
                        }
                        tablePanel.setSelected(false);
                    }
                } else {
                    this._pressed = null;
                    JDatabasePanel.this.selectRelationLine(evt);
                }
            }

            public void mouseDragged(MouseEvent evt) {
                if (this._pressed != null) {
                    Point p = evt.getPoint();
                    p.translate(-this._deltaX, -this._deltaY);
                    if (p.x < 0) {
                        p.x = 0;
                    }
                    if (p.y < 0) {
                        p.y = 0;
                    }
                    this._pressed.setLocation(p);
                    JDatabasePanel.this.updateRelationLines();
                    JDatabasePanel.this.setSize(JDatabasePanel.this.getPreferredSize());
                    JDatabasePanel.this.repaint();
                }
            }
        };
        this.addMouseListener(mouse);
        this.addMouseMotionListener(mouse);
    }

    public Dimension getSize() {
        int maxX = 0;
        int maxY = 0;
        Rectangle r = new Rectangle();
        Iterator tables = this._table2JTableMap.values().iterator();
        while (tables.hasNext()) {
            JTablePanel table = (JTablePanel)tables.next();
            r = table.getBounds(r);
            maxX = Math.max(maxX, r.x + r.width);
            maxY = Math.max(maxY, r.y + r.height);
        }
        Dimension d = new Dimension(maxX + 10, maxY + 10);
        return d;
    }

    public Dimension getMinimumSize() {
        return new Dimension(400, 600);
    }

    public Dimension getMaximumSize() {
        return this.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintRelationLines(g);
    }

    public void reset(Middlegen middlegen) {
        this._table2JTableMap.clear();
        this._lines.clear();
        this._ejbConfigurationMap.clear();
        this.removeAll();
        Iterator tables = middlegen.getTables().iterator();
        int i = 10;
        while (tables.hasNext()) {
            DbTable table = (DbTable)tables.next();
            if (!table.getTableElement().isGenerate()) continue;
            JTablePanel jTablePanel = new JTablePanel(table);
            this._tablePanels.add(jTablePanel);
            jTablePanel.getList().addListSelectionListener(this._columnSelectionListener);
            this.add(jTablePanel);
            this._table2JTableMap.put(table, jTablePanel);
            int x = table.getPrefsX();
            int y = table.getPrefsY();
            if (x == Integer.MIN_VALUE) {
                x = i;
                y = i;
            }
            jTablePanel.setLocation(x, y);
            i += 20;
        }
        this.validate();
        this.repaint();
        Iterator relations = middlegen.getRelations().iterator();
        while (relations.hasNext()) {
            this.addRelationLineMaybe((Relation)relations.next());
        }
        this.updateRelationLines();
        this.setSize(this.getPreferredSize());
        this.validate();
        this.repaint();
    }

    void setPrefs() {
        Iterator i = this._tablePanels.iterator();
        while (i.hasNext()) {
            JTablePanel tablePanel = (JTablePanel)i.next();
            DbTable table = tablePanel.getTable();
            int x = tablePanel.getX();
            int y = tablePanel.getY();
            table.setPosition(x, y);
        }
    }

    private void printHints() {
        System.out.println("********************************************************");
        System.out.println("* CTRL-Click relations to modify their cardinality     *");
        System.out.println("* SHIFT-Click relations to modify their directionality *");
        System.out.println("********************************************************");
    }

    private void selectRelationLine(MouseEvent evt) {
        Iterator i = this._lines.iterator();
        while (i.hasNext()) {
            RelationLine relationLine = (RelationLine)i.next();
            if (!relationLine.selectMaybe(evt)) continue;
            this._selectedRelationLine = relationLine;
            this.repaint();
            break;
        }
    }

    private void addRelationLineMaybe(Relation relation) {
        if (relation.isBothTablesGenerate()) {
            JTablePanel leftTable;
            if (relation.isMany2Many()) {
                _log.debug((Object)"Got ourself an m:n");
            }
            if ((leftTable = (JTablePanel)this._table2JTableMap.get(relation.getLeftTable())) == null) {
                throw new IllegalStateException("No JTablePane found for " + relation.getLeftTable().getSqlName() + " of class " + relation.getLeftTable().getClass().getName() + Middlegen.BUGREPORT);
            }
            JTablePanel rightTable = (JTablePanel)this._table2JTableMap.get(relation.getRightTable());
            if (rightTable == null) {
                throw new IllegalStateException("No JTablePane found for " + relation.getRightTable().getSqlName() + " of class " + relation.getRightTable().getClass().getName() + Middlegen.BUGREPORT);
            }
            RelationLine relationLine = new RelationLine(relation.getLeftRole(), relation.getRightRole(), leftTable, rightTable);
            this._lines.add(relationLine);
        }
    }

    private void updateRelationLines() {
        Iterator i = this._lines.iterator();
        while (i.hasNext()) {
            RelationLine relationLine = (RelationLine)i.next();
            relationLine.update();
        }
    }

    private void paintRelationLines(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Iterator i = this._lines.iterator();
        while (i.hasNext()) {
            RelationLine relationLine = (RelationLine)i.next();
            if (relationLine == this._selectedRelationLine) continue;
            relationLine.paint(g2d);
        }
        if (this._selectedRelationLine != null) {
            Color old = g.getColor();
            g.setColor(Color.white);
            this._selectedRelationLine.paint(g2d);
            g.setColor(old);
        }
    }

    private class RelationBuilder {
        private Table _leftTable = null;
        private Column _leftColumn = null;
        private Table _rightTable = null;
        private Column _rightColumn = null;

        RelationBuilder() {
        }
    }
}

